#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Thumbnail.pm 363 2007-03-16 15:11:10Z hikarin $
#

package Img0ch::Plugin::Upload::Thumbnail;

use strict;

sub create {
    my ($iApp)  = @_;
    my $iUpload = $iApp->upload();
    my $path    = $iUpload->get_uploaded_file_path();
    -r $path or return 0;

    my $iKernel    = $iApp->kernel();
    my $iConfig    = $iKernel->get_config();
    my $iSetting   = $iApp->setting();
    my $handler    = $iConfig->get('ImageHandler') || 'repng2jpeg';
    my $dest       = $path;
    my $max_width  = $iSetting->get_int('BBS_IMG_THUMBNAIL_X');
    my $max_height = $iSetting->get_int('BBS_IMG_THUMBNAIL_X');

    my ( $resno, $ext ) = $path =~ m{/(\d+)\.(\w+)\z}xms;
    my ( $width, $height ) = $iUpload->get_dimensions($path);
    my ( $scaled_width, $scaled_height )
        = $iUpload->scale( $width, $height, $max_width, $max_height );
    $dest =~ s{/(\d+\..+)\z}{/t$1}xms;

    if ( $handler eq 'repng2jpeg' ) {
        $ext ne 'jpg' and $ext ne 'gif' and $ext ne 'png' and return 1;
        my $binary = $^O eq 'MSWin32' ? 'repng2jpeg.exe' : 'repng2jpeg';
        my $repng2jpeg = join '/', $iConfig->get('SystemPath'), $binary;
        -x $repng2jpeg or $iKernel->throw_io_exception($repng2jpeg);

        $ENV{'PATH'} = '/usr/bin:/usr/local/bin';
        local ( $!, *FH );
        open *FH, "| ${repng2jpeg} ${path} ${dest}"    ## no critic
            . " ${scaled_width} ${scaled_height} 90"
            or $iKernel->throw_io_exception($repng2jpeg);
        close *FH or $iKernel->throw_io_exception($repng2jpeg);
    }
    elsif ( $handler eq 'GD' ) {
        require GD;
        $ext eq 'gif' and $GD::VERSION <= 2.15 and return 1;
        my $constructor = {
            'jpg' => sub { return GD::Image->newFromJpeg( $_[0] ) },
            'gif' => sub { return GD::Image->newFromGif( $_[0] ) },
            'png' => sub { return GD::Image->newFromPng( $_[0] ) },
            }->{$ext}
            || return 1;
        my $gd = GD::Image->new( $scaled_width, $scaled_height );
        my $src = $constructor->($path);
        $gd->copyResampled( $src, 0, 0, 0, 0, $scaled_width, $scaled_height,
            $width, $height );

        local ( $!, *FH );
        open *FH, ">${dest}"    ## no critic
            or $iKernel->throw_io_exception($dest);
        binmode *FH;
        if ( $ext eq 'jpg' ) {
            print {*FH} $gd->jpeg(100) or $iKernel->throw_io_exception($dest);
        }
        elsif ( $ext eq 'gif' ) {
            print {*FH} $gd->gif() or $iKernel->throw_io_exception($dest);
        }
        elsif ( $ext eq 'png' ) {
            print {*FH} $gd->png() or $iKernel->throw_io_exception($dest);
        }
        close *FH or $iKernel->throw_io_exception($dest);
    }
    elsif ( $handler eq 'PerlMagick' ) {
        require Image::Magick;
        my $magick = Image::Magick->new;
        $magick->Read($path);
        $magick->Scale( width => $scaled_width, height => $scaled_height );
        $magick->Write($dest);
    }
    else {
        return 1;
    }
    $iUpload->set_thumbnail_size( $resno, $scaled_width, $scaled_height );
    $iUpload->save();

    return 1;
}

1;
__END__
