#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Metadata.pm 363 2007-03-16 15:11:10Z hikarin $
#

package Zeromin::Metadata;

use strict;
use base qw(Img0ch::Metadata);

sub new {
    my ( $zClass, $iObject ) = @_;
    my $class = ref $iObject || '';
    my ( $zMeta, $iRepos );

    if ( $class eq 'Img0ch::BBS' or $class eq 'Zeromin::BBS' ) {
        $zMeta = $zClass->SUPER::new($iObject);
        $zMeta->{__kernel} = $iObject->get_kernel();
    }
    elsif ( $class eq 'Img0ch::Kernel' or $class eq 'Img0ch::Maple' ) {
        $zMeta = bless {
            _bbs => 'test',
            _common =>
                $iObject->get_repos( $iObject->get_repos_path('common') ),
            __kernel => $iObject,
        }, $zClass;
    }
    else {
        Img0ch::Kernel->throw_exception(
            'Img0ch::BBS or Img0ch::Maple(Img0ch::Kernel) not given');
    }

    $zMeta;
}

sub head { shift->_switch( 'head', 'head.txt', @_ ) }

sub meta { shift->_switch( 'meta', 'meta.txt', @_ ) }

sub foot { shift->_switch( 'foot', 'foot.txt', @_ ) }

sub main_banner { shift->_switch( 'banner.main', undef, @_ ) }

sub sub_banner { shift->_switch( 'banner.sub', undef, @_ ) }

sub mobile_banner { shift->_switch( 'banner.mobile', undef, @_ ) }

sub thread_end { shift->_switch( 'thread', '1000.txt', @_ ) }

sub remove {
    my ($zMeta) = @_;
    my ( $iRepos, $dir ) = ( $zMeta->{_system}, $zMeta->{_bbs} );
    $iRepos->remove("I:M.${dir}.head");
    $iRepos->remove("I:M.${dir}.meta");
    $iRepos->remove("I:M.${dir}.foot");
    $iRepos->remove("I:M.${dir}.thread");
    $iRepos->save();
    return 1;
}

sub _switch {
    my ( $zMeta, $type, $file, $content ) = @_;
    $content
        ? $zMeta->_save( $type, $file, $content )
        : $zMeta->_load( $type, ( $file ? 0 : 1 ) );
}

sub _save {
    my ( $zMeta, $type, $file, $content ) = @_;
    my ( $iReposCommon, $iReposSystem, $dir ) = (
        $zMeta->{_common}, $zMeta->{_system},
        ( $file ? $zMeta->{_bbs} : 'test' )
    );
    my $iKernel = $zMeta->{__kernel};

    require Zeromin::Plugin;
    my $zPlugin = Zeromin::Plugin->new($iKernel);
    $zPlugin->do( "zeromin.update.${type}", $zMeta,
        [ $zMeta->{_bbs}, $content ] );

    if ($file) {
        my $iKernel = $zMeta->{__kernel};
        my $base    = $iKernel->get_config()->get('BBSPath');
        my $path    = join '/', $base, $dir, $file;
        local ( $!, *FH );
        open *FH, '>', $path
            or $iKernel->throw_io_exception($path);
        print {*FH} ${$content}
            or $iKernel->throw_io_exception($path);
        close *FH or $iKernel->throw_io_exception($path);
        $iReposSystem->set_binary( "I:M.${dir}.${type}", $$content );
        $iReposSystem->save();
        $iReposCommon->remove("I:M.${dir}.${type}");
        $iReposCommon->save();
    }
    else {
        $iReposCommon->set_binary( "I:M.${type}", $$content );
        $iReposCommon->save();
    }

    return 1;
}

1;
__END__
