/*
 *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 * Img0ch.Setting
 * $Id: setting.js 528 2007-05-01 14:17:41Z hikarin $
 *
 * @require jquery.js
 */

var Img0ch;
if ( typeof Img0ch == "undefined" ) Img0ch = {};

Img0ch.Setting = function( base, bbs ) {
    var base_  = base;
    var bbs_   = bbs;
    var path_  = base + '/' + bbs + "/SETTING.TXT";
    var xml_   = jQuery.ajax({
        "async": false,
        "dataType": "text",
        "global": false,
        "type": "GET",
        "url": path_ });
    var content_ = {};
    if (xml_.status == 200) {
        var lines = xml_.responseText.split("\n");
        for ( var i in lines ) {
            var chunk = lines[i].split('=');
            content_[chunk[0]] = chunk[1];
        }
    }
    return {
        "get": function(key) {
            var ret = content_[key];
            return ret ? ret : '';
        },
        "getInteger": function(key) {
            var ret = content_[key];
            return isNaN(ret) ? 0 : Number(ret);
        },
        "getPath": function() { return path_ }
    };
};
