/*
 *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *  $Id: metadatapreview.js 963 2007-08-09 12:32:59Z hikarin $
 *
 *  @require jquery.js
 *
 */

var Zeromin2;
if (!Zeromin2) Zeromin2 = {};

Zeromin2.MetadataPreview = function(property) {
    var formId = property.formID;
    var content = property.content;
    var staticURI = property.staticURI;
    var typeTheme = property.typeTheme;
    var isTypeTheme = property.isTypeTheme;

    var formContainer = jQuery( "form#" + formId);
    var formContainerWidth = formContainer.width();
    var formContainerHeight = formContainer.height();
    formArea = jQuery("textarea[@name='content']").width(
        Math.round( ( formContainerWidth * 9.5 ) / 10 )).height(
        Math.round(formContainerHeight / 2));

    var previewFrame = jQuery("#previewFrame").show();
    var frameElement = jQuery( "iframe", previewFrame ).width(
        Math.round( ( formContainerWidth * 9.5 ) / 10 )).height(
        Math.round(formContainerHeight / 2)).css({
        "border": "1px solid #666" }).get(0);
    var frame = jQuery.browser.msie
        ? frameElement.contentWindow.document
        : frameElement.contentDocument;
    frame.body.innerHTML = content;

    if (!property.noHeader) {
        var url;
        if (isTypeTheme) {
            url = staticURI + "/tdiary/"
                + typeTheme + "/" + typeTheme + ".css";
        }
        else {
            url = staticURI + "/css/bbs.css";
        }
        var css = frame.createElement("link");
        css.rel = "stylesheet";
        css.type = "text/css";
        css.href = url;
        jQuery( "head", frame ).append(css);
    }

    var previewElement = jQuery( "div#preview", frame ).get(0);
    var feedback = function() {
        var formAreaValue = formArea.attr("value") || "";
        try {
            previewElement.innerHTML = formAreaValue.replace(
                /&lt;/g, "<" ).replace( /&gt;/g, ">" ).replace(
                /&quot;/g, "\"" ).replace( /&#39;/g, "'" ).replace(
                /&amp;/g, "&" );
        } catch(e) {
            Zeromin2.sendError(e);
        }
    };
    formArea.blur(feedback);
    feedback();
    return;
};
