#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Movie.pm 999 2007-08-29 12:57:14Z hikarin $
#

package Img0ch::Plugin::Rewrite::Movie;

use strict;
use Img0ch::Upload qw();

my $removeText = pack 'C*', 0x8d, 0xed, 0x8f, 0x9c;

sub new {
    my ( $iClass, $iBBS, $key ) = @_;
    my $iConfig = $iBBS->get_kernel()->get_config();
    my $iUpload = Img0ch::Upload->new( $iBBS, $key );
    my $bbs     = $iBBS->get_name();
    my $ufm
        = Img0ch::Request->get_app_uri2($iConfig)
        . '/img0ch-ufm.cgi/'
        . $bbs . '/';

    # this is hack.
    my $ua = $ENV{HTTP_USER_AGENT};

    bless {
        __bbs          => $bbs,
        __cache_key    => $key,
        __is_docomo    => ( $ua =~ /DoCoMo/xms ? 1 : 0 ),
        __is_au        => ( $ua =~ /UP\.Browser/xms ? 1 : 0 ),
        __i0_upload    => $iUpload,
        __removed_mark => $iUpload->removed_mark(),
        __ufm          => $ufm,
    }, $iClass;
}

sub from_mobile {
    my ( $iObject, $key, $count, $resno, $text, $param ) = @_;
    my $iUpload = $iObject->{__i0_upload};
    if ( $iObject->{__cache_key} ne $key ) {
        $iUpload->set_key($key);
        $iObject->{__cache_key} = $key;
        $iObject->{__i0_upload} = $iUpload;
    }

    my ( $extension, $width, $height, $hash ) = @{ $iUpload->get($resno) };
    $extension or return;
    my $file_url = join '/', $iUpload->url( $resno, $extension );

    if ( $hash eq $iObject->{__removed_mark} ) {
        $$text =~ s{\A.*?$file_url.*?\((.+?)\)<br>}
            {<b>[NOT_FOUND]</b><br>}xms;
    }
    elsif ( $iUpload->is_freezed($resno) ) {
        $$text =~ s{\A.*?$file_url.*?\((.+?)\)<br>}
            {<b>[UNDOWNLOADABLE]</b><br>}xms;
    }
    else {
        my $format;
        if (   $extension eq 'mpg'
            or $extension eq 'avi'
            or $extension eq 'wmv'
            or $extension eq 'wma'
            or $extension eq 'mp3'
            or $extension eq 'wav' )
        {
            $format = join( '',
                '<a href="http://fileseek.net/',
                'getmovie.html?', $file_url, '">[MOVIE:', uc($extension),
                '(FILESEEK.NET)]</a>' );
        }
        elsif ($extension eq '3gp'
            or $extension eq '3g2'
            or $extension eq 'amc' )
        {
            my $size = -s $iUpload->path( $resno, $extension );
            if ( $extension eq '3gp' and $size >= 307200 ) {
                my $file = 'img0ch.3gp.' . $resno;
                if ( $iObject->{__is_docomo} ) {
                    $format = join( '',
                        '<object declare id="',
                        $file,
                        '" data="',
                        $file_url,
                        '" type="video/3gpp">',
                        '<param name="stream-type" value="10" valuetype="data">',
                        '</object><a href="#',
                        $file,
                        '">[MOVIE:',
                        uc($extension),
                        ']</a>' );
                }
                else {
                    $format = join( '',
                        '<a href="',    $file_url, '">[MOVIE:',
                        uc($extension), ']</a>' );
                }
            }
            elsif ( $extension eq '3g2' and $size >= 307200 ) {
                if ( $iObject->{__is_docomo} ) {
                    my $file = 'img0ch.3g2.' . $resno;
                    $format = join( '',
                        '<object declare id="',
                        $file,
                        '" data="',
                        $file_url,
                        '" type="video/3gpp">',
                        '<param name="stream-type" value="10" valuetype="data">',
                        '</object><a href="#',
                        $file,
                        '">[MOVIE:',
                        uc($extension),
                        ']</a>' );
                }
                elsif ( $iObject->{__is_au} ) {
                    my $file = $resno . '.3g2';
                    $format = join( '',
                        '<object data="',
                        $file_url,
                        '" type="video/3gpp2" copyright="no" standby="[MOVIE:',
                        uc($extension),
                        ']">',
                        '<param name="disposition" value="devmpzz" valuetype="data" />',
                        '<param name="size" value="',
                        $size,
                        '" valuetype="data" />',
                        '<param name="title" value="',
                        $file,
                        '" valuetype="data" />',
                        '</object>' );
                }
                else {
                    $format = join( '',
                        '<a href="',    $file_url, '">[MOVIE:',
                        uc($extension), ']</a>' );
                }
            }
            elsif ( $extension eq 'amc' and $size >= 307200 ) {
                if ( $iObject->{__is_au} ) {
                    my $file = $resno . '.amc';
                    $format = join( '',
                        '<object data="',
                        $file_url,
                        '" type="application/x-mpeg" copyright="no" standby="[MOVIE:',
                        uc($extension),
                        ']">',
                        '<param name="disposition" value="devdl1q" valuetype="data" />',
                        '<param name="size" value="',
                        $size,
                        '" valuetype="data" />',
                        '<param name="title" value="',
                        $file,
                        '" valuetype="data" />',
                        '</object>' );
                }
                else {
                    $format = join( '',
                        '<a href="',    $file_url, '">[MOVIE:',
                        uc($extension), ']</a>' );
                }
            }
            elsif ( $extension eq '3gp' ) {
                if ( $iObject->{__is_docomo} ) {
                    my $file = 'img0ch.3gp.' . $resno;
                    $format = join( '',
                        '<object declare id="', $file,
                        '" data="',             $file_url,
                        '" type="video/3gpp">', '</object><a href="#',
                        $file,                  '">[MOVIE:',
                        uc($extension),         ']</a>' );
                }
                elsif ( $iObject->{__is_au} ) {
                    my $file = $resno . '.3gp';
                    $format = join( '',
                        '<object data="',
                        $file_url,
                        '" type="video/3gpp2" copyright="no" standby="[MOVIE:',
                        uc($extension),
                        ']">',
                        '<param name="disposition" value="devmpzz" valuetype="data"/>',
                        '<param name="size" value="',
                        $size,
                        '" valuetype="data" />',
                        '<param name="title" value="',
                        $file,
                        '" valuetype="data"/>',
                        '</object>' );
                }
                else {
                    $format = join( '',
                        '<a href="',    $file_url, '">[MOVIE:',
                        uc($extension), ']</a>' );
                }
            }
            elsif ( $extension eq '3g2' ) {
                if ( $iObject->{__is_docomo} ) {
                    my $file = 'img0ch.3g2.' . $resno;
                    $format = join( '',
                        '<object declare id="', $file,
                        '" data="',             $file_url,
                        '" type="video/3gpp">', '</object><a href="#',
                        $file,                  '">[MOVIE:',
                        uc($extension),         ']</a>' );
                }
                elsif ( $iObject->{__is_au} ) {
                    my $file = $resno . '.3g2';
                    $format = join( '',
                        '<object data="',
                        $file_url,
                        '" type="video/3gpp2" copyright="no" standby="[MOVIE:',
                        uc($extension),
                        ']">',
                        '<param name="disposition" value="devmpzz" valuetype="data" />',
                        '<param name="size" value="',
                        $size,
                        '" valuetype="data" />',
                        '<param name="title" value="',
                        $file,
                        '" valuetype="data" />',
                        '</object>' );
                }
                else {
                    $format = join( '',
                        '<a href="',    $file_url, '">[MOVIE:',
                        uc($extension), ']</a>' );
                }
            }
            elsif ( $extension eq 'amc' ) {
                if ( $iObject->{__is_au} ) {
                    my $file = $resno . '.amc';
                    $format = join( '',
                        '<object data="',
                        $file_url,
                        '" type="application/x-mpeg" copyright="no" standby="[MOVIE:',
                        uc($extension),
                        ']">',
                        '<param name="disposition" value="devdl1q" valuetype="data" />',
                        '<param name="size" value="',
                        $size,
                        '" valuetype="data" />',
                        '<param name="title" value="',
                        $file,
                        '" valuetype="data" />',
                        '</object>' );
                }
                else {
                    $format = join( '',
                        '<a href="',    $file_url, '">[MOVIE:',
                        uc($extension), ']</a>' );
                }
            }
            $$text =~ s{\A.+?\((.+?)\)<br\s?/?>}{${format}($1)<br>}xms;
        }
    }
    return;
}

1;
__END__
