#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Mock.pm 363 2007-03-16 15:11:10Z hikarin $
#

package Img0ch::Request::Mock;

use strict;
use base qw(Img0ch::Request::Interface);

sub new {
    my ( $iClass, $param, $header, $option ) = @_;
    $param  ||= {};
    $header ||= {};

    my $ip          = $option->{ip} || '127.0.0.1';
    my $bbs_tainted = $param->{bbs} || 'test';
    $bbs_tainted =~ /\A([\w\-]+)\z/xms;
    my $bbs = $1;
    my $key_tainted = $param->{key} || '0000000000';
    $key_tainted =~ /\A(\d\d\d\d\d\d\d\d\d\d?)\z/xms;
    my $key = $1;

    bless {
        __content => [],
        __header  => $header,
        __now     => ( $option->{now} || time() ),
        __msec    => ( $option->{msec} || int( rand(32678) ) ),
        __ip      => $ip,
        __bbs     => $bbs,
        __bbs     => $key,
        __ip_int  => pack( 'C4', ( split '\.', $ip ) ),
        _error    => '',
        __agent            => ( $option->{agent}     || 0 ),
        __sign             => '',
        __mocked_uri       => ( $option->{uri}       || '' ),
        __mocked_query     => ( $option->{query}     || '' ),
        __mocked_path_info => ( $option->{path_info} || '' ),
        __param            => $param
    }, $iClass;
}

sub request { }

sub signature { 'img0ch(CGI)/' . Img0ch::Maple->VERSION; }

*credit = \&signature;

sub init { }

sub param { $_[0]->{__param}->{ $_[1] } || '' }

sub get_header { $_[0]->{__header}->{ $_[1] } || '' }

sub set_header { $_[0]->{__header}->{ $_[1] } = $_[2] || '' }

sub rawdata { }

sub request_by_post { $_[0]->{__as_posted} ? 1 : 0 }

sub request_uri { $_[0]->{__mocked_uri} }

sub query { $_[0]->{__mocked_query} }

sub path_info { $_[0]->{__mocked_path_info} }

sub is_uploadable {0}

sub tempfile {''}

sub filename {''}

sub upload { }

sub cookie { }

sub enable_compress {
    $_[0]->{__header}->{'content-encoding'} = 'gzip';
    return;
}

sub send_http_header { }

sub print {
    my $iRequest = shift;
    map { push @{ $iRequest->{__content} }, ${$_} } @_;
    return;
}

1;
__END__
