/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.imodoki.extractor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.imodoki.extractor.ClassUtils;

public class Mark {
    private Map m_map = new HashMap();

    public void setMethodMarked(String className, String name, String signature) {
        className = className.replace('/', '.');
        signature = ClassUtils.canonicalizeMethodSignature(signature);
        this.addMark(className, name + signature);
    }

    public void setFieldMarked(String className, String name) {
        className = className.replace('/', '.');
        this.addMark(className, name);
    }

    public boolean isMethodMarked(String className, String name, String signature) {
        className = className.replace('/', '.');
        signature = ClassUtils.canonicalizeMethodSignature(signature);
        return this.isMarked(className, name + signature);
    }

    public boolean isFieldMarked(String className, String name) {
        className = className.replace('/', '.');
        return this.isMarked(className, name);
    }

    public void clear() {
        this.m_map.clear();
    }

    private void addMark(String className, String key) {
        HashSet<String> mark = (HashSet<String>)this.m_map.get(className);
        if (mark == null) {
            mark = new HashSet<String>();
            this.m_map.put(className, mark);
        }
        mark.add(key);
    }

    private boolean isMarked(String className, String key) {
        Set mark = (Set)this.m_map.get(className);
        if (mark == null) {
            return false;
        }
        return mark.contains(key);
    }
}

