/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.imodoki.extractor;

import java.io.IOException;
import java.util.Iterator;
import jp.sourceforge.imodoki.extractor.ClassMark;
import jp.sourceforge.imodoki.extractor.ClassPattern;
import jp.sourceforge.imodoki.extractor.ClassUtils;
import jp.sourceforge.imodoki.extractor.LinkageException;
import jp.sourceforge.imodoki.extractor.Mark;
import jp.sourceforge.imodoki.extractor.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.FieldOrMethod;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InvokeInstruction;

public class Marker {
    private Repository m_repository;
    private ClassPattern m_includePattern;
    private Mark m_mark;
    private ClassMark m_parametricMark;

    public Marker(Repository repository, ClassPattern includePattern, Mark mark) {
        this.m_repository = repository;
        this.m_includePattern = includePattern;
        this.m_mark = mark;
        this.m_parametricMark = new ClassMark();
    }

    public void preserveMethod(String className, String name, String signature) throws IOException, LinkageException {
        signature = ClassUtils.canonicalizeMethodSignature(signature);
        JavaClass clazz = this.m_repository.lookupClass(className);
        Method[] methods = clazz.getMethods();
        Method method = Marker.lookupMethod(methods, name, signature);
        if (method == null) {
            this.markSuperclassMethod(clazz, name, signature);
            return;
        }
        this.preserveMethod(clazz, method);
    }

    public void preserveMethod(JavaClass clazz, Method method) throws IOException, LinkageException {
        Marker.assertMethodBelongsToClass(method, clazz);
        String className = clazz.getClassName();
        String name = method.getName();
        String signature = ClassUtils.canonicalizeMethodSignature(method.getSignature());
        if (!this.m_mark.isMethodMarked(className, name, signature)) {
            this.m_mark.setMethodMarked(className, name, signature);
            if (this.m_includePattern.matches(className)) {
                Code code = method.getCode();
                if (code != null) {
                    this.markCode(code);
                }
            } else {
                int len = signature.length();
                int i = 1;
                while (i < len) {
                    if (signature.charAt(i) == 'L') {
                        int end = signature.indexOf(59, i + 1);
                        String argClsName = signature.substring(i + 1, end);
                        this.m_parametricMark.setMarked(argClsName);
                        i = end;
                    }
                    ++i;
                }
            }
        }
    }

    private void markSuperclassMethod(JavaClass clazz, String name, String signature) throws IOException, LinkageException {
        String className = clazz.getClassName();
        if (clazz.isInterface()) {
            String[] parents = clazz.getInterfaceNames();
            if (parents.length == 0) {
                throw new LinkageException("No such method: " + className + "." + name + signature);
            }
            boolean foundAny = false;
            int i = 0;
            while (i < parents.length) {
                try {
                    this.preserveMethod(parents[i], name, signature);
                    foundAny = true;
                }
                catch (LinkageException le) {
                    // empty catch block
                }
                ++i;
            }
            if (!foundAny) {
                throw new LinkageException("No such method: " + className + "." + name + signature);
            }
        } else {
            if (clazz.getSuperclassNameIndex() == 0) {
                throw new LinkageException("No such method: " + className + "." + name + signature);
            }
            this.preserveMethod(clazz.getSuperclassName(), name, signature);
        }
    }

    public void preserveField(String className, String name) throws IOException, LinkageException {
        if (!this.m_includePattern.matches(className)) {
            return;
        }
        JavaClass clazz = this.m_repository.lookupClass(className);
        Field[] fields = clazz.getFields();
        Field field = Marker.lookupField(fields, name);
        if (field == null) {
            if (!clazz.isInterface() && clazz.getSuperclassNameIndex() != 0) {
                this.preserveField(clazz.getSuperclassName(), name);
                return;
            }
            throw new LinkageException("No such field: " + className + "." + name);
        }
        this.m_mark.setFieldMarked(className, name);
        String type = ClassUtils.getComponentObject(field.getSignature());
        if (type != null && this.m_includePattern.matches(type)) {
            this.m_repository.lookupClass(type);
        }
    }

    private void markCode(Code code) throws IOException, LinkageException {
        InstructionList list = new InstructionList(code.getCode());
        ConstantPool cp = code.getConstantPool();
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            Instruction inst = ((InstructionHandle)itr.next()).getInstruction();
            if (inst instanceof InvokeInstruction) {
                InvokeInstruction invokeInst = (InvokeInstruction)inst;
                this.preserveMethod(Marker.getInstClassName((FieldOrMethod)invokeInst, cp), Marker.getInstName((FieldOrMethod)invokeInst, cp), Marker.getInstSignature((FieldOrMethod)invokeInst, cp));
                continue;
            }
            if (!(inst instanceof FieldInstruction)) continue;
            FieldInstruction fieldInst = (FieldInstruction)inst;
            this.preserveField(Marker.getInstClassName((FieldOrMethod)fieldInst, cp), Marker.getInstName((FieldOrMethod)fieldInst, cp));
        }
    }

    private static String getInstClassName(FieldOrMethod fm, ConstantPool cp) {
        ConstantCP cmr = (ConstantCP)cp.getConstant(fm.getIndex());
        return cmr.getClass(cp);
    }

    private static String getInstName(FieldOrMethod fm, ConstantPool cp) {
        ConstantCP cmr = (ConstantCP)cp.getConstant(fm.getIndex());
        ConstantNameAndType cnat = (ConstantNameAndType)cp.getConstant(cmr.getNameAndTypeIndex());
        return cnat.getName(cp);
    }

    private static String getInstSignature(FieldOrMethod fm, ConstantPool cp) {
        ConstantCP cmr = (ConstantCP)cp.getConstant(fm.getIndex());
        ConstantNameAndType cnat = (ConstantNameAndType)cp.getConstant(cmr.getNameAndTypeIndex());
        return cnat.getSignature(cp);
    }

    private boolean markPolymorphic() throws IOException, LinkageException {
        boolean marked = false;
        JavaClass[] classes = this.m_repository.getClasses();
        int i = 0;
        while (i < classes.length) {
            JavaClass clazz = classes[i];
            if (!clazz.isInterface()) {
                String className = clazz.getClassName();
                Method[] methods = clazz.getMethods();
                int j = 0;
                while (j < methods.length) {
                    Method method = methods[j];
                    if (!method.isStatic() && !method.isPrivate() && !this.m_mark.isMethodMarked(className, method.getName(), method.getSignature()) && (this.isMethodMarkedParent(clazz, method.getName(), method.getSignature(), clazz.getPackageName()) || this.m_includePattern.matches(className) && this.isMethodUnresolvedAbstract(clazz, method.getName(), method.getSignature()))) {
                        this.preserveMethod(clazz, method);
                        marked = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return marked;
    }

    private boolean isMethodMarkedParent(JavaClass clazz, String name, String signature, String origPackage) throws IOException {
        Method[] methods;
        if (name.equals("<init>")) {
            return false;
        }
        String[] ifs = clazz.getInterfaceNames();
        int i = 0;
        while (i < ifs.length) {
            JavaClass iface = this.m_repository.lookupClass(ifs[i]);
            methods = iface.getMethods();
            Method ifMethod = Marker.lookupMethod(methods, name, signature);
            if (ifMethod != null && this.m_mark.isMethodMarked(ifs[i], name, signature)) {
                return true;
            }
            if (this.isMethodMarkedParent(iface, name, signature, origPackage)) {
                return true;
            }
            ++i;
        }
        if (clazz.isInterface() || clazz.getSuperclassNameIndex() == 0) {
            return false;
        }
        JavaClass superClass = this.m_repository.lookupClass(clazz.getSuperclassName());
        methods = superClass.getMethods();
        Method superMethod = Marker.lookupMethod(methods, name, signature);
        if (superMethod != null) {
            if (superMethod.isPrivate() || !superMethod.isProtected() && !superMethod.isPublic() && !superClass.getPackageName().equals(origPackage)) {
                return false;
            }
            if (this.m_mark.isMethodMarked(superClass.getClassName(), name, signature)) {
                return true;
            }
        }
        return this.isMethodMarkedParent(superClass, name, signature, origPackage);
    }

    /*
     * Unable to fully structure code
     */
    private boolean isMethodUnresolvedAbstract(JavaClass clazz, String name, String signature) throws IOException {
        if (name.equals("<init>")) {
            return false;
        }
        ifs = clazz.getInterfaceNames();
        i = 0;
        while (i < ifs.length) {
            ifname = ifs[i];
            iface = this.m_repository.lookupClass(ifname);
            if (!this.m_includePattern.matches(ifname) && (ifMethod = Marker.lookupMethod(methods = iface.getMethods(), name, signature)) != null) {
                return true;
            }
            if (this.isMethodUnresolvedAbstract(iface, name, signature)) {
                return true;
            }
            ++i;
        }
        if (!clazz.isInterface()) ** GOTO lbl22
        return false;
lbl-1000:
        // 1 sources

        {
            superClass = this.m_repository.lookupClass(clazz.getSuperclassName());
            methods = superClass.getMethods();
            superMethod = Marker.lookupMethod(methods, name, signature);
            if (superMethod != null) {
                return superMethod.isAbstract() != false && this.m_includePattern.matches(superClass.getClassName()) == false;
            }
            clazz = superClass;
lbl22:
            // 2 sources

            ** while (clazz.getSuperclassNameIndex() != 0)
        }
lbl23:
        // 1 sources

        return false;
    }

    private boolean markParametric() throws IOException, LinkageException {
        boolean marked = false;
        JavaClass[] classes = this.m_repository.getClasses();
        int i = 0;
        while (i < classes.length) {
            JavaClass clazz = classes[i];
            String className = clazz.getClassName();
            if (!this.m_includePattern.matches(className) && this.isClassParametric(clazz)) {
                Method[] methods = clazz.getMethods();
                int j = 0;
                while (j < methods.length) {
                    Method method = methods[j];
                    if (!(method.isStatic() || method.isPrivate() || method.getName().equals("<init>") || this.m_mark.isMethodMarked(className, method.getName(), method.getSignature()))) {
                        this.preserveMethod(clazz, method);
                        marked = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return marked;
    }

    private boolean isClassParametric(JavaClass clazz) throws IOException {
        String className = clazz.getClassName();
        if (this.m_parametricMark.isMarked(className)) {
            return true;
        }
        String[] ifs = clazz.getInterfaceNames();
        int i = 0;
        while (i < ifs.length) {
            String ifname = ifs[i];
            if (this.m_parametricMark.isMarked(ifname)) {
                this.m_parametricMark.setMarked(className);
                return true;
            }
            JavaClass iface = this.m_repository.lookupClass(ifname);
            if (this.isClassParametric(iface)) {
                this.m_parametricMark.setMarked(className);
                return true;
            }
            ++i;
        }
        if (clazz.isInterface() || clazz.getSuperclassNameIndex() == 0) {
            return false;
        }
        JavaClass superClass = this.m_repository.lookupClass(clazz.getSuperclassName());
        if (this.isClassParametric(superClass)) {
            this.m_parametricMark.setMarked(className);
            return true;
        }
        return false;
    }

    private boolean markClinit() throws IOException, LinkageException {
        boolean marked = false;
        JavaClass[] classes = this.m_repository.getClasses();
        int i = 0;
        while (i < classes.length) {
            String signature;
            String name;
            Method[] methods;
            Method method;
            JavaClass clazz = classes[i];
            String className = clazz.getClassName();
            if (this.m_includePattern.matches(className) && (method = Marker.lookupMethod(methods = clazz.getMethods(), name = "<clinit>", signature = "()")) != null && !this.m_mark.isMethodMarked(className, name, signature)) {
                this.preserveMethod(clazz, method);
                marked = true;
            }
            ++i;
        }
        return marked;
    }

    public void postProcess() throws IOException, LinkageException {
        do {
            boolean cont = this.markParametric();
            cont |= this.markPolymorphic();
        } while (cont |= this.markClinit());
    }

    private static Method lookupMethod(Method[] methods, String name, String signature) {
        signature = ClassUtils.canonicalizeMethodSignature(signature);
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().equals(name) && methods[i].getSignature().startsWith(signature)) {
                return methods[i];
            }
            ++i;
        }
        return null;
    }

    private static Field lookupField(Field[] fields, String name) {
        int i = 0;
        while (i < fields.length) {
            if (fields[i].getName().equals(name)) {
                return fields[i];
            }
            ++i;
        }
        return null;
    }

    private static void assertMethodBelongsToClass(Method method, JavaClass clazz) {
        Method[] methods = clazz.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i] == method) {
                return;
            }
            ++i;
        }
        throw new RuntimeException("Assertion failed");
    }
}

