/*
 * $Id: Graphics.java,v 1.8 2003/04/06 01:50:47 ymakise Exp $
 */

/*
 * ΥեΥ饤󥹤ϰʲΤ褦 BSD 饤󥹤˽򤷤ޤ
 * 㳰ȤơiɤѴġˤäѴ줿Ѵ
 *  MIDP ץꥱղä줿󥿥饤֥ΥХʥ
 * ˤĤƤϡiɤԤϤʤ븢ĥʤΤȤޤ
 *
 * Copyright (c) 2002-2003, MAKISE Yoshitaro
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. Neither the name of the iModoki nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.nttdocomo.ui;

public class Graphics {
    public static final int BLACK   = 0;
    public static final int BLUE    = 1;
    public static final int LIME    = 2;
    public static final int AQUA    = 3;
    public static final int RED     = 4;
    public static final int FUCHSIA = 5;
    public static final int YELLOW  = 6;
    public static final int WHITE   = 7;
    public static final int GRAY    = 8;
    public static final int NAVY    = 9;
    public static final int GREEN   = 10;
    public static final int TEAL    = 11;
    public static final int MAROON  = 12;
    public static final int PURPLE  = 13;
    public static final int OLIVE   = 14;
    public static final int SILVER  = 15;

    private static final int[] COLOR_OF_NAME = {
        0x000000, 0x0000ff, 0x00ff00, 0x00ffff,
        0xff0000, 0xff00ff, 0xffff00, 0xffffff,
        0x808080, 0x000080, 0x008000, 0x008080,
        0x800000, 0x800080, 0x808000, 0xc0c0c0
    };

    private javax.microedition.lcdui.Graphics m_graphics;
    private javax.microedition.lcdui.Canvas m_midpCanvas;
    private Canvas m_canvas;
//#DOUBLE_BUFFERING{
    private int m_lockCount;
    /** unlock() Ǽºݤ˺褹뤫ɤ̵ºƵɤΥե饰
        MIDPCanvas ѹ */
    boolean m_systemLock = false;
//#DOUBLE_BUFFERING}

    protected Graphics() {
        // Don't call this
    }

    Graphics(javax.microedition.lcdui.Canvas midpCanvas,
             Canvas canvas) {
        m_midpCanvas = midpCanvas;
        m_canvas = canvas;
//#DOUBLE_BUFFERING{
        m_lockCount = 0;
//#DOUBLE_BUFFERING}
    }

    void setMIDPGraphics(javax.microedition.lcdui.Graphics graphics) {
        m_graphics = graphics;

        setOrigin(0, 0);
        setColor(getContrastColor(m_canvas.getBackground()));
        setFont(Font.getDefaultFont());
    }

    public Graphics copy() {
        // TODO: ߡǤʤ
        //       Τ񤷤ʤƻȤʤ
        //       褦Ȥȥ̤Τ̤
        return null;
    }

    public void dispose() {
        m_graphics = null;
    }

    public void lock() {
//#DOUBLE_BUFFERING{
        synchronized (this) {
            m_lockCount++;
        }
//#DOUBLE_BUFFERING}
    }

    public void unlock(boolean forced) {
//#DOUBLE_BUFFERING{
        int lockCnt;

        synchronized (this) {
            if (forced) {
                m_lockCount = 0;
            } else if (m_lockCount > 0) {
                m_lockCount--;
            }
            lockCnt = m_lockCount;
        }

        if (lockCnt == 0) {
            if (!m_systemLock) {
                m_midpCanvas.repaint();
            }
        }
//#DOUBLE_BUFFERING}
    }

    public void setOrigin(int x, int y) {
        m_graphics.translate(x - m_graphics.getTranslateX(),
                             y - m_graphics.getTranslateY());
    }

    public static int getColorOfRGB(int r, int g, int b) {
//#STRICTER_ERROR_CHECKING{
        if (r < 0 || r > 255 || g < 0 || g > 255 || b < 0 || g > 255)
            throw new IllegalArgumentException();
//#STRICTER_ERROR_CHECKING}

        return r << 16 | g << 8 | b;
    }

    public static int getColorOfName(int name) {
//#STRICTER_ERROR_CHECKING{
        if (name < BLACK || name > SILVER)
            throw new IllegalArgumentException();
//#STRICTER_ERROR_CHECKING}

        return COLOR_OF_NAME[name];
    }

    public void setColor(int c) {
        m_graphics.setColor(c);
    }

    public void setFont(Font f) {
//#STRICTER_ERROR_CHECKING{
        if (f == null)
            throw new NullPointerException();
//#STRICTER_ERROR_CHECKING}

        m_graphics.setFont(f.getMIDPFont());
    }

    public void clearRect(int x, int y, int width, int height) {
//#STRICTER_ERROR_CHECKING{
        if (width < 0 || height < 0)
            throw new IllegalArgumentException();
//#STRICTER_ERROR_CHECKING}

        int oldColor = m_graphics.getColor();
        m_graphics.setColor(m_canvas.getBackground());
        m_graphics.fillRect(x, y, width, height);
        m_graphics.setColor(oldColor);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        m_graphics.drawLine(x1, y1, x2, y2);
    }

    public void drawRect(int x, int y, int width, int height) {
        if (width < 0 || height < 0)
            throw new IllegalArgumentException();

        m_graphics.drawRect(x, y, width, height);
    }

    public void fillRect(int x, int y, int width, int height) {
        if (width < 0 || height < 0)
            throw new IllegalArgumentException();

        m_graphics.fillRect(x, y, width, height);
    }

    public void drawImage(Image img, int x, int y) {
        m_graphics.drawImage(img.getMIDPImage(), x, y,
                             (javax.microedition.lcdui.Graphics.TOP |
                             javax.microedition.lcdui.Graphics.LEFT));
    }

//#FILLPOLYGON_ACTUALLY_FILL{

    /** fillPolygon()   եꥹȹ¤ */
    private static class EdgeBuf {
        public int X;           // Xɸ(ͤϻXɸ)
        public int Y0;          // Yɸ
        public int Y1;          // Yɸ
        public int a;           // (dX/dY)
    }

//#FILLPOLYGON_ACTUALLY_FILL}

    public void fillPolygon(int[] xPts, int[] yPts, int nPts) {
//#STRICTER_ERROR_CHECKING{
        if (nPts < 0 || xPts.length < nPts || yPts.length < nPts)
            throw new IllegalArgumentException();
//#STRICTER_ERROR_CHECKING}

        if (nPts < 3) {
            return;
        }

//#FILLPOLYGON_ACTUALLY_FILL{

        /*
         * ¿ѷɤĤ֤
         * (16 * ĺ) ХȰʾΥ񤹤롣
         *
         * : Fussy's Homepage - 르ꥺξҲ
         * http://web.ffn.ne.jp/~fussy/argo.htm
         */

        // TODO: Ȥޤ魯

        int i;
        int MINY = 0;
        int MAXY = m_midpCanvas.getHeight() - 1;

        /*----- ΰγ -----*/

        /* եꥹȥɥ쥹Ǽ */
        /* ʿʬ뤿ᡢեꥹȤǤĺκʬ-1
           ݤOK롼פʬ+1ΤǷǿ nPts */
        /* +1ƤΤϥȻֿͤɬפ뤿 */
        EdgeBuf[] edgeBufPtr = new EdgeBuf[nPts + 1];
        for (i = 0; i < nPts; i++) {
            edgeBufPtr[i] = new EdgeBuf();
        }

        /*----- եꥹȤκ -----*/

        int eidx = 0;

        for (i = 0; i < nPts; i++) {
            int x = xPts[i];
            int y = yPts[i];
            int nx, ny;
            if (i < nPts - 1) {
                nx = xPts[i + 1];
                ny = yPts[i + 1];
            } else {
                nx = xPts[0];
                ny = yPts[0];
            }
            int dx = nx - x;
            int dy = ny - y;
            if ( dy != 0 ) {
                EdgeBuf eBuf = edgeBufPtr[eidx];
                eBuf.X = ( dy > 0 ) ? x << 16 : nx << 16;
                if (dy > 0) {
                    eBuf.Y0 = y;
                    eBuf.Y1 = ny;
                } else {
                    eBuf.Y0 = ny;
                    eBuf.Y1 = y;
                }
                eBuf.a = ( dx << 16 ) / dy;
                eidx++;
            }
        }

        /*----- ɤĤ֤ -----*/

        EdgeBuf eof = new EdgeBuf();
        int nonactiveEdgeIdx, activeEdgeIdx, epp;

        eof.X = Integer.MAX_VALUE;

        /* ƤեꥹȤ̤ƥ֡פˤ */
        nonactiveEdgeIdx = eidx - 1;

        activeEdgeIdx = nonactiveEdgeIdx;
        /* ֥ƥ֡פեꥹȤֿͤߤ(Ȼɬ) */
        edgeBufPtr[activeEdgeIdx + 1] = eof;

        for (int y = MINY; y <= MAXY; y++) {
            /* yȻפ̤ƥ֡פդ֥ƥ֡פˤ */
            for (epp = 0; epp <= nonactiveEdgeIdx; ) {
                if (edgeBufPtr[epp].Y0 == y) {
                    EdgeBuf ep = edgeBufPtr[epp];
                    edgeBufPtr[epp] = edgeBufPtr[nonactiveEdgeIdx];
                    edgeBufPtr[nonactiveEdgeIdx--] = ep;
                } else {
                    epp++;
                }
            }

            /* Ƚפ֥ƥ֡פդ */
            for (epp = nonactiveEdgeIdx + 1; epp <= activeEdgeIdx; ) {
                if ( edgeBufPtr[epp].Y1 == y ) {
                    edgeBufPtr[epp] = edgeBufPtr[activeEdgeIdx];
                    edgeBufPtr[activeEdgeIdx--] = eof;
                } else {
                    epp++;
                }
            }

            /* Υ() */
            int dataStart = nonactiveEdgeIdx + 1, dataEnd = activeEdgeIdx;
            for (i = dataEnd - 1; i >= dataStart; i--) {
                EdgeBuf p = edgeBufPtr[i];
                int j;
                for (j = i + 1; edgeBufPtr[j].X < p.X; j++)
                    edgeBufPtr[j - 1] = edgeBufPtr[j];
                edgeBufPtr[j - 1] = p;
            }

            /* 饤 */
            for (epp = nonactiveEdgeIdx + 1; epp < activeEdgeIdx; epp += 2) {
                int x0 = (int)(edgeBufPtr[epp].X >> 16);
                int x1 = (int)(edgeBufPtr[epp + 1].X >> 16);

                m_graphics.drawLine(x0, y, x1, y);

                /* غɸι */
                edgeBufPtr[epp].X += edgeBufPtr[epp].a;
                edgeBufPtr[epp + 1].X += edgeBufPtr[epp + 1].a;
            }
        }

//#}FILLPOLYGON_ACTUALLY_FILL{

        /* ¿ѷɤĤ֤Ȥ */

        for (int i = 0; i < nPts - 1; i++) {
            m_graphics.drawLine(xPts[i], yPts[i],
                                xPts[i + 1], yPts[i + 1]);
        }
        m_graphics.drawLine(xPts[nPts - 1], yPts[nPts - 1],
                            xPts[0], yPts[0]);

//#FILLPOLYGON_ACTUALLY_FILL}
    }

    public void drawPolyline(int[] xPts, int[] yPts, int nPts) {
//#STRICTER_ERROR_CHECKING{
        if (nPts < 0 || xPts.length < nPts || yPts.length < nPts)
            throw new IllegalArgumentException();
//#STRICTER_ERROR_CHECKING}

        if (nPts == 1) {
            m_graphics.drawLine(xPts[0], yPts[0], xPts[0], yPts[0]);
        } else {
            for (int i = 0; i < nPts - 1; i++) {
                m_graphics.drawLine(xPts[i], yPts[i],
                                    xPts[i + 1], yPts[i + 1]);
            }
        }
    }

    public void drawString(String str, int x, int y) {
//#STRICTER_ERROR_CHECKING{
        if (str == null)
            throw new NullPointerException();
//#STRICTER_ERROR_CHECKING}

        m_graphics.drawString(str, x, y,
                              javax.microedition.lcdui.Graphics.BASELINE |
                              javax.microedition.lcdui.Graphics.LEFT);
    }

    public void drawChars(char[] data, int x, int y, int off, int len) {
//#STRICTER_ERROR_CHECKING{
        if (data == null)
            throw new NullPointerException();

        if (off < 0 || len < 0 || off + len > data.length)
            throw new IllegalArgumentException();
//#STRICTER_ERROR_CHECKING}

        m_graphics.drawChars(data, off, len, x, y,
                             javax.microedition.lcdui.Graphics.BASELINE |
                             javax.microedition.lcdui.Graphics.LEFT);
    }

    /** Ϳ줿ȥȥ饹ȤΤ뿧֤ */
    private static int getContrastColor(int color) {
        int r = (color >> 16) & 0xff;
        int g = (color >> 8) & 0xff;
        int b = color & 0xff;

        if (r + g + b < 0x80 * 3)       // ŤߤŤ򤷤ۤ?
            return 0xffffff;
        else
            return 0x000000;
    }
}
