/*
 * $Id: ClassFileInspector.java,v 1.5 2003/04/06 01:50:50 ymakise Exp $
 */

/*
 * Copyright (c) 2002-2003, MAKISE Yoshitaro
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. Neither the name of the iModoki nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package jp.sourceforge.imodoki.converter;

import java.io.*;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantCP;
import org.apache.bcel.classfile.ConstantNameAndType;

/**
 * 饹եϤơȤƤ᥽åɤʤɤĴ٤롣
 */
public class ClassFileInspector {
    private JavaClass m_class;
    private ConstantPool m_cpool;

    /**
     * 󥹥ȥ饯
     *
     * @param  is        饹եΥХϥȥ꡼ࡣ
     * @param  fileName  饹եΥե̾
     */
    public ClassFileInspector(InputStream is, String fileName)
        throws IOException {
        ClassParser parser = new ClassParser(is, fileName);
        m_class = parser.parse();
        m_cpool = m_class.getConstantPool();
        is.close();
    }

    /**
     * оݤΥ饹᥽åɤθƤӽФԤʤäƤ뤫
     * ɤĴ٤롣
     *
     * @param  clazz  ᥽åɤƤ륯饹̾
     *                󥿡եǤ褤
     * @param  name   ᥽åɤ̾
     * @param  type   ᥽åɤηͥ㡣饹ե
     *                ͥɽƱʸ
     */
    public boolean callsMethod(String clazz, String name, String type) {
        /* ȴ󥹥ȥ饯󥳡ɤޤĴ٤ΤǤϤʤ
           󥹥ȥס˥ȥ꤬뤫ɤĴ٤Ƥ롣 */
        
        clazz = clazz.replace('/', '.');

        for (int i = 1; i < m_cpool.getLength(); i++) {
            Constant item = m_cpool.getConstant(i);
            if (item instanceof ConstantCP) {
                ConstantCP cp = (ConstantCP)item;
                ConstantNameAndType nt = (ConstantNameAndType)
                    m_cpool.getConstant(cp.getNameAndTypeIndex(),
                                        Constants.CONSTANT_NameAndType);
                if (cp.getClass(m_cpool).equals(clazz) &&
                    nt.getName(m_cpool).equals(name) &&
                    nt.getSignature(m_cpool).equals(type)) {
                    return true;
                }
            }
        }

        return false;
    }
}
