/*
 * $Id: JarFileInspector.java,v 1.3 2003/04/06 01:50:50 ymakise Exp $
 */

/*
 * Copyright (c) 2002-2003, MAKISE Yoshitaro
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. Neither the name of the iModoki nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package jp.sourceforge.imodoki.converter;

import java.io.*;
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Enumeration;
import java.util.zip.ZipFile;
import java.util.zip.ZipEntry;

/**
 * jar եϤơȤƤ᥽åɤʤɤĴ٤롣
 */
public class JarFileInspector {
    private ZipFile m_zipFile;
    private List m_classInspectors;

    /**
     * 󥹥ȥ饯
     *
     * @param  file  jar եΥե̾ɽ File ֥ȡ
     */
    public JarFileInspector(File file) throws IOException {
        m_zipFile = new ZipFile(file);
        m_classInspectors = new ArrayList();

        Enumeration e = m_zipFile.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = (ZipEntry)e.nextElement();
            String name = entry.getName();
            if (name.endsWith(".class") && !entry.isDirectory()) {
                ClassFileInspector inspector =
                    new ClassFileInspector(m_zipFile.getInputStream(entry),
                                           name);
                m_classInspectors.add(inspector);
            }
        }
    }

    /**
     * jar եΥ饹᥽åɤθƤӽФԤʤäƤ뤫
     * ɤĴ٤롣
     *
     * @param  clazz  ᥽åɤƤ륯饹̾
     *                󥿡եǤ褤
     * @param  name   ᥽åɤ̾
     * @param  type   ᥽åɤηͥ㡣饹ե
     *                ͥɽƱʸ
     */
    public boolean callsMethod(String clazz, String name, String type) {
        for (Iterator itr = m_classInspectors.iterator(); itr.hasNext(); ) {
            ClassFileInspector inspector = (ClassFileInspector)itr.next();
            if (inspector.callsMethod(clazz, name, type)) {
                return true;
            }
        }

        return false;
    }

    /**
     * Ȥ˻Ȥä꥽롣
     */
    public void close() throws IOException {
        m_zipFile.close();
    }
}
