/*
 * $Id: Main.java,v 1.7 2003/04/06 01:50:50 ymakise Exp $
 */

/*
 * Copyright (c) 2002-2003, MAKISE Yoshitaro
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. Neither the name of the iModoki nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package jp.sourceforge.imodoki.converter;

import java.io.File;
import java.io.PrintStream;
import java.net.URL;
import java.net.MalformedURLException;
import java.util.*;
import jp.sourceforge.imodoki.util.OptionParser;
import jp.sourceforge.imodoki.util.OptionParserException;

/**
 * Ѵġᥤ
 */
public class Main {
    public static final String VERSION = "0.0.2";

    private static URL s_jamURL = null;
    private static ConverterOption s_converterOption;
    private static RuntimeCompileOption s_compileOption;

    public static void main(String[] args) {
        boolean success = internalMain(args);
        System.exit(success ? 0 : 1);
    }

    public static boolean internalMain(String[] args) {
        s_converterOption = new ConverterOption();
        s_converterOption.setDebugBuild(false);
        s_converterOption.setOutputDir(new File("."));
        s_converterOption.setWorkDir(null);
        s_converterOption.setKeepWorkDir(false);
        s_converterOption.setVerbosity(ConverterOption.TERSE);

        s_compileOption = new RuntimeCompileOption();

        parseArgs(args);

        if (s_converterOption.getWorkDir() == null) {
            s_converterOption.setWorkDir(
                new File(s_converterOption.getOutputDir(), "imodoki.workdir"));
        }

        Converter converter =
            new Converter(s_jamURL, s_converterOption, s_compileOption);
        boolean success = converter.convert();

        return success;
    }

    private static void parseArgs(String[] args) {
        boolean verbose = false, debug = false;

        OptionParser optParser = new OptionParser();
        optParser.addOption("-e", "<id...>",
            "Specify comma-separeted IDs of runtime configuration\n" +
            "option to enable");
        optParser.addOption("-d", "<id...>",
            "Specify comma-separeted IDs of runtime configuration\n" +
            "option to disable");
        optParser.addOption("-debugbuild",
            "Produce debug build (not perform shrinking)");
        optParser.addOption("-outputdir", "<dir>",
            "Specify output directory (default: .)");
        optParser.addOption("-workdir", "<dir>",
            "Specify work directory\n" +
            "(default: $outputdir/imodoki.workdir)");
        optParser.addOption("-keep-workdir",
            "Keep work directory and not perform build");
        optParser.addOption("-verbose",
            "Verbose execution");
        optParser.addOption("-debug",
            "Print debugging information");
        optParser.addOption("-version",
            "Show version and exit");
//         optParser.addOption("-targerprofile", "<profile>",
//             "Specify target profile (default: MIDP)\n" +
//             "one of these: MIDP, KDDIP1, KDDIP2, JPHONE");
//         optParser.addOption("-jadtemplate", "<file>",
//             "Specify templete of output .jad file");
        optParser.addOption("-help",
            "Show this help");

        try {
            String opt;
            while ((opt = optParser.parse(args)) != null) {
                if (opt.equals("-e")) {
                    String list = optParser.getOptionArg();
                    addCompileOption(list, true);
                } else if (opt.equals("-d")) {
                    String list = optParser.getOptionArg();
                    addCompileOption(list, false);
                } else if (opt.equals("-debugbuild")) {
                    s_converterOption.setDebugBuild(true);
                } else if (opt.equals("-outputdir")) {
                    String outputDir = optParser.getOptionArg();
                    s_converterOption.setOutputDir(new File(outputDir));
                } else if (opt.equals("-workdir")) {
                    String workDir = optParser.getOptionArg();
                    s_converterOption.setWorkDir(new File(workDir));
                } else if (opt.equals("-keep-workdir")) {
                    s_converterOption.setKeepWorkDir(true);
                } else if (opt.equals("-verbose")) {
                    verbose = true;
                } else if (opt.equals("-debug")) {
                    debug = true;
                } else if (opt.equals("-version")) {
                    System.out.println("iModoki converter version " + VERSION);
                    System.exit(0);
                } else if (opt.equals("-help")) {
                    usage(optParser);
                    System.exit(0);
                } else {
                    throw new RuntimeException("Unreachable");
                }
            }
        } catch (OptionParserException ope) {
            System.err.println(ope.getMessage());
            System.exit(1);
        }

        int verbosity = ConverterOption.TERSE;
        if (debug) {
            verbosity = ConverterOption.DEBUG;
        } else if (verbose) {
            verbosity = ConverterOption.VERBOSE;
        }
        s_converterOption.setVerbosity(verbosity);

        String[] restArgs = optParser.getArgs();
        if (restArgs.length != 1) {
            usage(optParser);
            System.exit(1);
        }

        String arg = restArgs[0];

        try {
            /* http:// ʤɤΥץȥǻϤޤäƤ */
            s_jamURL = new URL(arg);
        } catch (MalformedURLException urle) {
            /* ե̾ξ */
            File file = new File(arg);
            if (!file.isFile()) {
                System.err.println("Not a file: `" + file + "'");
                System.exit(1);
            }
            try {
                s_jamURL = file.toURL();
            } catch (MalformedURLException urle2) {
                // Τ
                System.err.println(urle2);
                System.exit(1);
            }
        }
    }

    private static void addCompileOption(String list, boolean value) {
        StringTokenizer st = new StringTokenizer(list, ",");
        while (st.hasMoreTokens()) {
            String id = st.nextToken().trim();
            try {
                s_compileOption.getBoolean(id);
                s_compileOption.setValue(id, value);
            } catch (IllegalArgumentException iae) {
                System.err.println("Unrecognized runtime configuration option: " + id);
                System.exit(1);
            }
        }
    }

    public static void usage(OptionParser optParser) {
        System.out.println("usage: imodokic [options...] {jamfile|jamurl}");
        System.out.println();
        System.out.println("options:");
        optParser.printUsage(System.out, 2, 20);

        System.out.println();
        System.out.println("runtime configuration options:");
        SortedSet keys = new TreeSet(s_compileOption.getOptionIDs());
        Iterator itr = keys.iterator();
        while (itr.hasNext()) {
            String id = (String)itr.next();
            boolean val;
            try {
                val = s_compileOption.getBoolean(id);
            } catch (IllegalArgumentException iae) {
                continue;
            }
            System.out.println("  " + id + " (default: " +
                               (val ? "enabled" : "disabled") + ")");
        }
        System.out.println();
    }
}
