/*
 * $Id: IModokiExtractorDriver.java,v 1.9 2003/04/06 01:50:49 ymakise Exp $
 */

/*
 * Copyright (c) 2002-2003, MAKISE Yoshitaro
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. Neither the name of the iModoki nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package jp.sourceforge.imodoki.shrinker;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.ArrayList;
import java.util.zip.Deflater;
import jp.sourceforge.imodoki.util.CollectionUtils;
import jp.sourceforge.imodoki.util.ExecUtils;
import jp.sourceforge.imodoki.util.FileUtils;
import jp.sourceforge.imodoki.util.NullOutputStream;

/**
 * iɤ Extractor Υɥ饤С
 */
public class IModokiExtractorDriver implements ToolDriver {
    private static final String MAIN_CLASS =
        "jp.sourceforge.imodoki.extractor.Extractor";

    private File m_extractorJar = null;

    /**
     * 󥹥ȥ饯
     */
    public IModokiExtractorDriver() {
        File toolDir = new File(System.getProperty(Shrinker.EXTTOOLS_DIR));
        m_extractorJar = ShrinkerUtils.findToolJar(toolDir, MAIN_CLASS);
    }

    public boolean available() {
        return (m_extractorJar != null);
    }

    public String getName() {
        return "iModoki Extractor";
    }

    public void process(String classPath, File inputJar, File outputJar,
                        String[] preserves, int verbosity)
        throws IOException {
        if (!available()) {
            return;
        }

        String[] includedClasses =
            ShrinkerUtils.findClasses(inputJar);

        File tempDir = new File(Shrinker.s_tempDir, "extractor_res");
        try {
            tempDir.mkdir();

            /* ꥽ե */
            FileUtils.expandZip(inputJar, tempDir,
                                ShrinkerUtils.ZIPENTRY_RESOURCE_FILTER);

            List args = new ArrayList();
            args.add("-classpath");
            args.add(classPath + File.pathSeparator + inputJar.getPath());
            args.add("-includecls");
            args.add(CollectionUtils.join(includedClasses, ","));
            args.add("-preserve");
            args.add(CollectionUtils.join(preserves, ","));
            args.add("-output");
            args.add(outputJar.getPath());
            if (verbosity >= ToolDriver.VERBOSE) {
                args.add("-verbose");
            }

            String[] args_ary = (String[])args.toArray(new String[0]);

            if (verbosity >= ToolDriver.DEBUG) {
                System.out.println("Calling iModoki Extractor in " +
                                   m_extractorJar +
                                   " with args: " +
                                   CollectionUtils.join(args_ary, " "));
            } else if (verbosity >= ToolDriver.VERBOSE) {
                String[] args_ary2 = (String[])args_ary.clone();
                for (int i = 0; i < args_ary2.length; i++) {
                    String elem = args_ary2[i];
                    if (elem.length() >= 128) {
                        elem = elem.substring(0, 116) + "...(omitted)";
                        args_ary2[i] = elem;
                    }
                }
                System.out.println("Calling iModoki Extractor in " +
                                   m_extractorJar +
                                   " with args: " +
                                   CollectionUtils.join(args_ary2, " "));
            }

            PrintStream oldOut = System.out;
            if (verbosity <= ToolDriver.QUIET) {
                System.setOut(new PrintStream(new NullOutputStream()));
            }

            ExecUtils.execJava(m_extractorJar.getPath(),
                               MAIN_CLASS, args_ary, false);

            if (verbosity < ToolDriver.QUIET) {
                System.setOut(oldOut);
            }

            /* ꥽ե᤹ */
            FileUtils.updateJar(outputJar, tempDir, null, null,
                                Deflater.NO_COMPRESSION);
        } finally {
            FileUtils.deleteRecursive(tempDir);
        }
    }
}
