/*
 * $Id: JAXDriver.java,v 1.10 2003/04/06 01:50:49 ymakise Exp $
 */

/*
 * Copyright (c) 2002-2003, MAKISE Yoshitaro
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. Neither the name of the iModoki nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package jp.sourceforge.imodoki.shrinker;

import java.io.*;
import java.util.zip.Deflater;
import org.apache.bcel.classfile.Utility;
import jp.sourceforge.imodoki.util.CollectionUtils;
import jp.sourceforge.imodoki.util.ExecUtils;
import jp.sourceforge.imodoki.util.FileUtils;
import jp.sourceforge.imodoki.util.NullOutputStream;

/* 

   - JAX 6.1/7.3 ϰ JDK  VerifierError ˤʤ롣
     java ޥɤ -noverify ץĤư
     :
         http://www.alphaworks.ibm.com/forum/jax.nsf/6129dbc33537f2d2852564c2005948e2/b396325a4e9a3ed1bb760bddf65adb5e?OpenDocument
   - JAX 6.1 Ǥ -notransform դʤ verifier ̤ʤ
     饹ե뤳Ȥ롣7.3 Ǥ̤ǧ
 */

/**
 * JAX (IBM) Υɥ饤С
 */
public class JAXDriver implements ToolDriver {
    private static final String MAIN_CLASS = "com.ibm.jax.Batch";

    private File m_jaxJar = null;

    /**
     * 󥹥ȥ饯
     */
    public JAXDriver() {
        File toolDir = new File(System.getProperty(Shrinker.EXTTOOLS_DIR));
        m_jaxJar = ShrinkerUtils.findToolJar(toolDir, MAIN_CLASS);
    }

    public boolean available() {
        return (m_jaxJar != null);
    }

    public String getName() {
        return "JAX";
    }

    public void process(String classPath, File inputJar, File outputJar,
                        String[] preserves, int verbosity)
        throws IOException {

        if (!available()) {
            return;
        }

        File configFile = null;
        File logFile = null;
        File tempDir = null;
        try {
            String[] includedClasses =
                ShrinkerUtils.findClasses(inputJar);

            /* JAX 6.1 ΥХ(?)ǡե̾ '/' ޤʤΤ
               ȥǥ쥯ȥե */
            configFile = File.createTempFile("shrinker_jax", ".jax",
                                             new File("."));
            writeConfigFile(configFile, classPath, inputJar,
                            includedClasses, preserves);

            logFile = new File(Shrinker.s_tempDir, "shrinker_jax.log");

            /* ꥽ե */
            tempDir = new File(Shrinker.s_tempDir, "jax_res");
            tempDir.mkdir();
            FileUtils.expandZip(inputJar, tempDir,
                                ShrinkerUtils.ZIPENTRY_RESOURCE_FILTER);

            String[] args = new String[] {
                "-logfilename",
                logFile.getPath(),
                "-zipfilename",
                outputJar.getPath(),
//                 "-notransform",
                configFile.getName()
            };

            if (verbosity >= ToolDriver.VERBOSE) {
                System.out.println("Running JAX in " + m_jaxJar +
                                   " with args: " +
                                   CollectionUtils.join(args, " "));
            }

            if (verbosity >= ToolDriver.DEBUG) {
                System.out.println("----- Config file -----");
                ShrinkerUtils.dumpFile(configFile, System.out);
                System.out.println("----- Config file End -----");
            }

            PrintStream oldOut = System.out;
            if (verbosity >= ToolDriver.VERBOSE ||
                verbosity <= ToolDriver.QUIET) {
                System.setOut(new PrintStream(new NullOutputStream()));
            }

            ExecUtils.execJava(m_jaxJar.getPath(),
                               MAIN_CLASS, args, true);

            if (verbosity >= ToolDriver.VERBOSE ||
                verbosity <= ToolDriver.QUIET) {
                System.setOut(oldOut);
                if (verbosity >= ToolDriver.VERBOSE) {
                    ShrinkerUtils.dumpFile(logFile, System.out);
                }
            }

            /* ꥽ե᤹ */
            FileUtils.updateJar(outputJar, tempDir, null, null,
                                Deflater.NO_COMPRESSION);
        } finally {
            if (tempDir != null) {
                FileUtils.deleteRecursive(tempDir);
            }
            if (configFile != null) {
                configFile.delete();
            }
            if (logFile != null) {
                logFile.delete();
            }
        }
    }

    private static void writeConfigFile(File configFile,
                                        String classPath, File inputJar,
                                        String[] includedClasses,
                                        String[] preserves)
        throws IOException {
        PrintWriter pw = new PrintWriter(new FileWriter(configFile));

        pw.println("#PATH " + classPath + ";" + inputJar);

        for (int i = 0; i < includedClasses.length; i++) {
            pw.println("#INCLUDECLASS " + includedClasses[i]);
        }

        for (int i = 0; i < preserves.length; i++) {
            String member = preserves[i];
            int idx;
            idx = member.indexOf('(');
            if (idx != -1) {
                String args = member.substring(idx);
                String[] args_ary = Utility.methodSignatureArgumentTypes(args, false);
                args = CollectionUtils.join(args_ary, ",");
                String name = member.substring(0, idx);
                pw.println("#PRESERVEMETHOD " + name + "(" + args + ")");
            } else {
                pw.println("#PRESERVEFIELD " + member);
            }
        }

        pw.close();
    }
}
