/*
 * $Id: JargDriver.java,v 1.8 2003/04/06 01:50:49 ymakise Exp $
 */

/*
 * Copyright (c) 2002-2003, MAKISE Yoshitaro
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. Neither the name of the iModoki nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package jp.sourceforge.imodoki.shrinker;

import java.io.File;
import java.io.IOException;
import java.util.*;
import jp.sourceforge.imodoki.util.CollectionUtils;
import jp.sourceforge.imodoki.util.ExecUtils;
import jp.sourceforge.imodoki.util.FileUtils;

/**
 * jarg (http://jarg.sourceforge.net) Υɥ饤С
 */
public class JargDriver implements ToolDriver {
    private static final String MAIN_CLASS = "jarg.Jarg";

    private File m_jargJar = null;

    /**
     * 󥹥ȥ饯
     */
    public JargDriver() {
        File toolDir = new File(System.getProperty(Shrinker.EXTTOOLS_DIR));
        m_jargJar = ShrinkerUtils.findToolJar(toolDir, MAIN_CLASS);
    }

    public boolean available() {
        return (m_jargJar != null);
    }

    public String getName() {
        return "jarg";
    }

    public void process(String classPath, File inputJar, File outputJar,
                        String[] preserves, int verbosity)
        throws IOException {

        if (!available()) {
            return;
        }

        File workDir = new File(Shrinker.s_tempDir, "jarg");
        try {
            workDir.mkdir();

            File inFile = new File(workDir, "input.jar");
            File outFile = new File(workDir, "input_s.jar");
            FileUtils.copyFile(inputJar, inFile);

            List args = new ArrayList();
            args.add("-nocomp");
            if (verbosity >= ToolDriver.DEBUG) {
                args.add("-verboseall");
            } else if (verbosity >= ToolDriver.VERBOSE) {
                args.add("-verbose");
            } else if (verbosity >= ToolDriver.TERSE) {
                args.add("-showstat");
            }
            Set prc = ShrinkerUtils.getPreservedClasses(preserves);
            for (Iterator itr = prc.iterator(); itr.hasNext(); ) {
                args.add("-main");
                args.add(itr.next());
            }
            args.add(inFile.getPath());

            String[] args_ary = (String[])args.toArray(new String[0]);

            if (verbosity >= ToolDriver.VERBOSE) {
                System.out.println("Running jarg in " + m_jargJar +
                                   " with args: " +
                                   CollectionUtils.join(args_ary, " "));
            }

            // jarg λȤäƤ BCEL Ȥ礦Τ fork=true
            ExecUtils.execJava(m_jargJar.getPath(),
                               MAIN_CLASS, args_ary, true);

            if (outFile.renameTo(outputJar) == false) {
                FileUtils.copyFile(outFile, outputJar);
            }
        } finally {
            FileUtils.deleteRecursive(workDir);
        }
    }
}
