/*
 * $Id: ProGuardDriver.java,v 1.10 2003/04/06 01:50:49 ymakise Exp $
 */

/*
 * Copyright (c) 2002-2003, MAKISE Yoshitaro
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. Neither the name of the iModoki nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package jp.sourceforge.imodoki.shrinker;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.ArrayList;
import org.apache.bcel.classfile.Utility;
import jp.sourceforge.imodoki.util.CollectionUtils;
import jp.sourceforge.imodoki.util.ExecUtils;
import jp.sourceforge.imodoki.util.NullOutputStream;
import jp.sourceforge.imodoki.util.ClassPathClassLoader;

/**
 * ProGuard(http://proguard.sourceforge.net) Υɥ饤С
 * ProGuard 1.4 ʹߤб
 */
public class ProGuardDriver implements ToolDriver {
    private static final String MAIN_CLASS = "proguard.ProGuard";

    private File m_proguardJar = null;

    /**
     * 󥹥ȥ饯
     */
    public ProGuardDriver() {
        File toolDir = new File(System.getProperty(Shrinker.EXTTOOLS_DIR));
        m_proguardJar = ShrinkerUtils.findToolJar(toolDir, MAIN_CLASS);
    }

    public boolean available() {
        return (m_proguardJar != null);
    }

    public String getName() {
        return "ProGuard";
    }

    public void process(String classPath, File inputJar, File outputJar,
                        String[] preserves, int verbosity)
        throws IOException {

        if (!available()) {
            return;
        }

        List args = new ArrayList();
        args.add("-libraryjars");
        args.add(classPath);
        args.add("-injars");
        args.add(inputJar.getPath());
        args.add("-outjar");
        args.add(outputJar.getPath());
        args.add("-overloadaggressively");
        args.add("-defaultpackage");
        args.add("a");
        if (verbosity >= ToolDriver.VERBOSE) {
            args.add("-verbose");
            args.add("-printusage");
        }
        if (verbosity >= ToolDriver.DEBUG) {
            args.add("-printseeds");
            args.add("-printmapping");
        }

        SignatureGetter sigGetter = new SignatureGetter(inputJar.getPath());
        for (int i = 0; i < preserves.length; i++) {
            args.add("-keep");
            args.add(getMemberSpec(preserves[i], sigGetter));
        }
        sigGetter.close();

        String[] args_ary = (String[])args.toArray(new String[0]);

        if (verbosity >= ToolDriver.VERBOSE) {
            String[] args_ary2 = (String[])args_ary.clone();
            for (int i = 0; i < args_ary2.length; i++) {
                String elem = args_ary2[i];
                if (elem.indexOf(' ') != -1) {
                    elem = '"' + elem + '"';
                    args_ary2[i] = elem;
                }
            }
            System.out.println("Calling ProGuard in " + m_proguardJar +
                               " with args: " +
                CollectionUtils.join(args_ary2, " "));
        }

        PrintStream oldOut = System.out;
        if (verbosity <= ToolDriver.QUIET) {
            System.setOut(new PrintStream(new NullOutputStream()));
        }

        callProGuard(m_proguardJar.getPath(), args_ary);
//         ExecUtils.execJava(m_proguardJar.getPath(),
//                            MAIN_CLASS, args_ary, true);

        if (verbosity <= ToolDriver.QUIET) {
            System.setOut(oldOut);
        }
    }

    private static void callProGuard(String classPath, String[] args)
        throws IOException {
        try {
            ClassLoader loader = new ClassPathClassLoader(classPath);
            Class clsOptions =
                Class.forName("proguard.ProGuardOptions", true, loader);
            Class clsParser =
                Class.forName("proguard.CommandParser", true, loader);
            Class clsProGuard =
                Class.forName("proguard.ProGuard", true, loader);
            Constructor ctorParser =
                clsParser.getConstructor(new Class[] { String[].class });
            Method mthParse =
                clsParser.getMethod("parse", new Class[] { clsOptions });
            Constructor ctorProGuard =
                clsProGuard.getConstructor(new Class[] { clsOptions });
            Method mthExecute =
                clsProGuard.getMethod("execute", null);

/*
            proguard.ProGuardOptions options = new proguard.ProGuardOptions();
            proguard.CommandParser parser = new proguard.CommandParser(args);
            parser.parse(options);
            proguard.ProGuard proGuard = new proguard.ProGuard(options);
            proGuard.execute();
 */
            Object options = clsOptions.newInstance();
            Object parser = ctorParser.newInstance(new Object[] { args });
            mthParse.invoke(parser, new Object[] { options });
            Object proGuard =
                ctorProGuard.newInstance(new Object[] { options });
            mthExecute.invoke(proGuard, null);

        } catch (ClassNotFoundException cnfe) {
            throw new IOException("Class not found: " + cnfe.toString());
        } catch (NoSuchMethodException nsme) {
            throw new IOException("Method not found: " + nsme.toString());
        } catch (IllegalAccessException iae) {
            throw new IOException("Illegal access: " + iae.toString());
        } catch (InstantiationException ie) {
            throw new IOException("Instantiation failed: " + ie.toString());
        } catch (InvocationTargetException ite) {
            Throwable te = ite.getTargetException();
//             te.printStackTrace();
            throw new IOException("Exception occurred: " + te.toString());
        }
    }

    private static String getMemberSpec(String member,
                                        SignatureGetter sigGetter)
        throws IOException {
        String signature = sigGetter.getSignature(member);
        String clname = ShrinkerUtils.getClassSpec(member);
        String name = ShrinkerUtils.getNameSpec(member);

        int idx2 = name.indexOf('(');
        if (idx2 != -1) {
            name = name.substring(0, idx2);
            String[] args_ary =
                Utility.methodSignatureArgumentTypes(signature, false);
            String args = CollectionUtils.join(args_ary, ",");
            String ret = Utility.methodSignatureReturnType(signature, false);

            return "class " + clname + " { " + ret + " " + name +
                "(" + args + "); }";
        } else {
            String ret = Utility.signatureToString(signature, false);
            return "class " + clname + " { " + ret + " " + name + "; }";
        }
    }
}
