/*
 * $Id: RetroGuardDriver.java,v 1.9 2003/04/06 01:50:49 ymakise Exp $
 */

/*
 * Copyright (c) 2002-2003, MAKISE Yoshitaro
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. Neither the name of the iModoki nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package jp.sourceforge.imodoki.shrinker;

import java.io.*;
import java.util.Set;
import java.util.Iterator;
import jp.sourceforge.imodoki.util.CollectionUtils;
import jp.sourceforge.imodoki.util.ExecUtils;

/**
 * RetroGuard Υɥ饤С
 */
public class RetroGuardDriver implements ToolDriver {
    private static final String MAIN_CLASS = "RetroGuard";

    private File m_retroguardJar = null;

    /**
     * 󥹥ȥ饯
     */
    public RetroGuardDriver() {
        File toolDir = new File(System.getProperty(Shrinker.EXTTOOLS_DIR));
        m_retroguardJar = ShrinkerUtils.findToolJar(toolDir, MAIN_CLASS);
    }

    public boolean available() {
        return (m_retroguardJar != null);
    }

    public String getName() {
        return "RetroGuard";
    }

    public void process(String classPath, File inputJar, File outputJar,
                        String[] preserves, int verbosity)
        throws IOException {

        if (!available()) {
            return;
        }

        File scriptFile = null;
        File logFile = null;
        try {
            scriptFile = new File(Shrinker.s_tempDir, "retroguard.rgs");
            writeScriptFile(scriptFile, inputJar, preserves);

            logFile = new File(Shrinker.s_tempDir, "retroguard.log");

            String[] args = new String[] {
                inputJar.getPath(),
                outputJar.getPath(),
                scriptFile.getPath(),
                logFile.getPath()
            };

            if (verbosity >= ToolDriver.VERBOSE) {
                System.out.println("Running RetroGuard in " +
                                   m_retroguardJar + " with args: " +
                                   CollectionUtils.join(args, " "));
            }

            if (verbosity >= ToolDriver.DEBUG) {
                System.out.println("----- Script file -----");
                ShrinkerUtils.dumpFile(scriptFile, System.out);
                System.out.println("----- Script file End -----");
            }

            /* RetroGuard ϥ饤֥ꥯ饹βˡVM Υ饹ѥ
               ȤΤǡѤʥ饹ѥΤɤ fork=true */
            ExecUtils.execJava(classPath + File.pathSeparator +
                               m_retroguardJar.getPath(),
                               MAIN_CLASS, args, true);

            if (verbosity >= ToolDriver.VERBOSE) {
                System.out.println("----- Log file -----");
                ShrinkerUtils.dumpFile(logFile, System.out);
                System.out.println("----- Log file End -----");
            }
        } finally {
            if (scriptFile != null) {
                scriptFile.delete();
            }
            if (logFile != null) {
                logFile.delete();
            }
        }
    }

    private static void writeScriptFile(File scriptFile, File inputJar,
                                        String[] preserves)
        throws IOException {
        SignatureGetter sigGetter = new SignatureGetter(inputJar.getPath());
        PrintWriter pw = new PrintWriter(new FileWriter(scriptFile));

        for (int i = 0; i < preserves.length; i++) {
            String member = preserves[i];
            String signature = sigGetter.getSignature(member);
            member = member.replace('.', '/').replace('#', '/');
            int idx;
            idx = member.indexOf('(');
            if (idx != -1) {
                member = member.substring(0, idx);
                if (!member.endsWith("<init>")) {
                    pw.println(".method " + member + " " + signature);
                }
            } else {
                pw.println(".field " + member + " " + signature);
            }
        }

        sigGetter.close();

        Set set = ShrinkerUtils.getPreservedClasses(preserves);
        for (Iterator itr = set.iterator(); itr.hasNext(); ) {
            String clazz = (String)itr.next();
            clazz = clazz.replace('.', '/');
            pw.println(".class " + clazz);
        }

        pw.close();
    }
}
