/*
 * $Id: ShrinkerUtils.java,v 1.7 2003/04/06 01:50:49 ymakise Exp $
 */

/*
 * Copyright (c) 2002-2003, MAKISE Yoshitaro
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. Neither the name of the iModoki nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package jp.sourceforge.imodoki.shrinker;

import java.io.*;
import java.util.*;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipFile;
import java.util.zip.ZipEntry;
import jp.sourceforge.imodoki.util.FileUtils;
import jp.sourceforge.imodoki.util.StringUtils;
import jp.sourceforge.imodoki.util.ZipEntryFilter;

/**
 * Shrinker ѤΥ桼ƥƥ
 */
public class ShrinkerUtils {
    /**
     * ꤵ줿 zip եϥǥ쥯ȥ˴ޤޤ륯饹ΰ롣
     *
     * @param  path  zip եϥǥ쥯ȥꡣ
     * @return 饹̾
     *
     * @exception IOException  ϥ顼ΤȤ
     */
    public static String[] findClasses(File path) throws IOException {
        if (path.isDirectory()) {
            return findClassesDir(path);
        } else {
            return findClassesZip(path);
        }
    }

    private static String[] findClassesDir(File path) throws IOException {
        List result = new ArrayList();

        String[] list =
            FileUtils.listRecursive(path, FileUtils.CLASSFILENAME_FILTER);
        for (int i = 0; i < list.length; i++) {
            String fname = list[i];
            String className = fname.replace(File.separatorChar, '.');
            result.add(className);
        }

        return (String[])result.toArray(new String[0]);
    }

    private static String[] findClassesZip(File path) throws IOException {
        List result = new ArrayList();

        ZipInputStream zis = new ZipInputStream(
            new BufferedInputStream(new FileInputStream(path)));
        try {
            ZipEntry entry;
            while((entry = zis.getNextEntry()) != null) {
                String name = entry.getName();
                if (name.endsWith(".class") && !entry.isDirectory()) {
                    String className =
                        name.substring(0, name.length() - 6).replace('/', '.');
                    result.add(className);
                }
                zis.closeEntry();
            }
        } finally {
            zis.close();
        }

        return (String[])result.toArray(new String[0]);
    }

    /**
     * ꥽ե (饹եʳΥե) Ƥ
     * ZipEntryFilter
     */
    public static ZipEntryFilter ZIPENTRY_RESOURCE_FILTER =
    new ZipEntryFilter() {
        public boolean accept(ZipEntry entry) {
            if (!entry.getName().endsWith(".class")) {
                return true;
            } else {
                return false;
            }
        }
    };

    /**
     * ꤵ줿ǥ쥯ȥ꤫顢Υ饹ޤ jar ե
     * Ĥ롣
     *
     * @param  dir        jar եõǥ쥯ȥꡣ
     * @param  className  õ饹̾
     * @return jar ե롣Ĥʤ null ֤
     */
    public static File findToolJar(File dir, String className) {
        String entryName = className.replace('.', '/') + ".class";

        File[] files = dir.listFiles(JARFILE_FILTER);

        for (int i = 0; i < files.length; i++) {
            File file = files[i];
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(file);
                ZipEntry entry = zipFile.getEntry(entryName);
                if (entry != null && !entry.isDirectory()) {
                    return file;
                }
            } catch (IOException ioe) {
                System.err.println("Warning: " + ioe);
            } finally {
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    } catch (IOException ioe2) {
                        System.err.println("Warning: " + ioe2);
                    }
                }
            }
        }

        return null;
    }

    /** jar, zip ե˥ޥå FileFilter */
    private static final FileFilter JARFILE_FILTER = new FileFilter() {
        public boolean accept(File file) {
            if (file.isFile()) {
                String name = file.getName();
                if (StringUtils.endsWithIgnoreCase(name, ".zip") ||
                    StringUtils.endsWithIgnoreCase(name, ".jar")) {
                    return true;
                }
            }
            return false;
        }
    };

    /**
     * եƤꤵ줿ȥ꡼˽Ϥ롣
     * ե뤬ĤʤˤϷٹФ³롣
     *
     * @param  file  եɽ File ֥ȡ
     * @param  out   ϥȥ꡼ࡣ
     */
    public static void dumpFile(File file, OutputStream out) {
        InputStream is = null;
        try {
            is = new FileInputStream(file);
        } catch (FileNotFoundException fnfe) {
            System.err.println("Warning: file " + file + " not found");
            return;
        }

        try {
            FileUtils.copyStream(is, out);

            is.close();
        } catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    /**
     * ¸᥽åɡեɤλ꤫顢
     * 饹̾ʬФ
     *
     * @param  spec  ᥽åϥեɤλꡣ
     * @return 饹̾ʬ
     */
    public static String getClassSpec(String spec) {
        int idx = spec.lastIndexOf('.');
        if (idx == -1) {
            throw new IllegalArgumentException("Bad member spec: " + spec);
        }
        String clazz = spec.substring(0, idx);
        return clazz;
    }

    /**
     * ¸᥽åɡեɤλ꤫顢
     * ̾ʬФ
     *
     * @param  spec  ᥽åϥեɤλꡣ
     * @return ̾᥽åɤξϰΥͥ⡣
     */
    public static String getNameSpec(String spec) {
        int idx = spec.lastIndexOf('.');
        if (idx == -1) {
            throw new IllegalArgumentException("Bad member spec: " + spec);
        }
        String nt = spec.substring(idx + 1);
        return nt;
    }

    /**
     * ¸᥽åɡեɤλ꤫顢
     * ¸٤饹̾롣
     * ߤμǤϡ饹̾ʬФƤ
     *
     * @param  preservers  ¸᥽åɡեɡ
     * @return 饹̾ Set
     */
    public static Set getPreservedClasses(String[] preserves) {
        Set set = new HashSet();

        for (int i = 0; i < preserves.length; i++) {
            String member = preserves[i];
            String clazz = getClassSpec(member);
            set.add(clazz);
        }

        return set;
    }
}
