/*
 * $Id: SignatureGetter.java,v 1.4 2003/04/06 01:50:49 ymakise Exp $
 */

/*
 * Copyright (c) 2002-2003, MAKISE Yoshitaro
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. Neither the name of the iModoki nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package jp.sourceforge.imodoki.shrinker;

import java.io.InputStream;
import java.io.IOException;
import java.util.Map;
import java.util.HashMap;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Field;
import jp.sourceforge.imodoki.util.ClassPath;

/**
 * ᥽åɤեɤԴʥͥ㤫顢
 * ֤ͤޤ᤿ʥͥ롣
 * RetroGuard Υץȥեϥ᥽åɤ֤ͤ
 * եɤηޤǻꤷʤȤʤΤǡк
 */
class SignatureGetter {
    private ClassPath m_classPath;
    private Map m_classes;

    /**
     * 󥹥ȥ饯
     */
    public SignatureGetter(String classPath) {
        m_classPath = new ClassPath(classPath);
        m_classes = new HashMap();
    }

    /**
     * ᥽åɤեɤԴʥͥ㤫
     * ʥͥ롣
     *
     * @param  spec  Դʥͥ㡣
     *                : "java.lang.String.indexOf(Ljava/lang/String;I)"
     *                    "java.awt.Rectangle.width"
     * @return ᥽åɤեɤδʥͥ㡣
     *         ᥽åɤեɤ̾ϴޤޤʤ
     *              : "(Ljava/lang/String;I)I"
     *                  "Ljava/lang/String;"
     * @exception IOException
     *         饹᥽åɡեɤ¸ߤʤȤ
     *         ޤϥ顼Ȥꤲ롣
     */
    public String getSignature(String spec) throws IOException {
        String className = ShrinkerUtils.getClassSpec(spec);
        Map signatures = (Map)m_classes.get(className);
        if (signatures == null) {
            signatures = loadClass(className);
        }

        String name = ShrinkerUtils.getNameSpec(spec);
        name = stripReturnType(name);

        String result = (String)signatures.get(name);
        if (result == null) {
            throw new IOException("Field or method not found: " + spec);
        }
        return result;
    }

    /** ˥饹ɤ߹ m_classes ɲä롣 */
    private Map loadClass(String className) throws IOException {
        InputStream is = m_classPath.getInputStream(className);
        ClassParser parser = new ClassParser(is, className);
        JavaClass clazz = parser.parse();
        is.close();

        Map signatures = new HashMap();
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; i++) {
            String key = methods[i].getName() +
                stripReturnType(methods[i].getSignature());
            String value = methods[i].getSignature();
            signatures.put(key, value);
        }
        Field[] fields = clazz.getFields();
        for (int i = 0; i < fields.length; i++) {
            String key = fields[i].getName();
            String value = fields[i].getSignature();
            signatures.put(key, value);
        }

        m_classes.put(className, signatures);

        return signatures;
    }

    /**
     * Ѥ꥽롣
     */
    public void close() {
        try {
            m_classPath.close();
        } catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    /**
     * ᥽åɥͥ㤫֤ͤη롣
     * եɥͥξϲ⤷ʤ
     */
    private static String stripReturnType(String sig) {
        int idx = sig.indexOf(')');
        if (idx != -1) {
            return sig.substring(0, idx + 1);
        } else {
            return sig;
        }

    }
}
