/*
 * $Id: ToolDriver.java,v 1.6 2003/04/06 01:50:49 ymakise Exp $
 */

/*
 * Copyright (c) 2002-2003, MAKISE Yoshitaro
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. Neither the name of the iModoki nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package jp.sourceforge.imodoki.shrinker;

import java.io.File;
import java.io.IOException;

/**
 * Ƽġɥ饤Фζ̥󥿡ե
 */
public interface ToolDriver {
    /** Verbosity level */
    public static final int QUIET = 0;
    public static final int TERSE = 1;
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;

    /**
     * Υɥ饤ФѲǽǤ뤫ݤ֤
     *
     * @return ѲǽǤ true
     */
    public boolean available();

    /**
     * Υɥ饤Фġ֤̾
     *
     * @return ġ̾
     */
    public String getName();

    /**
     * ̾Ԥʤ
     *
     * @param  classPath  饤֥ꥯ饹ѥ
     *                    ץåȥե¸η
     *                    inputZip ϴޤޤ٤Ǥʤ
     * @param  inputJar   ץꥱ jar ե롣
     * @param  outputJar  Ϥ jar ե롣
     * @param  preserves  Ϥ˴ޤ᥽åɡեɤλꡣ
     *                    "java.lang.String.indexOf(Ljava/lang/String;I)"
     *                    Τ褦ʷ
     * @param  verbosity  Verbosity ٥롣
     * @exception IOException
     *                    ϥ顼Ȥꤲ롣
     */
    public void process(String classPath, File inputJar, File outputJar,
                        String[] preserves, int verbosity)
        throws IOException;
}
