/*
 * $Id: ExecUtils.java,v 1.6 2003/04/06 01:50:49 ymakise Exp $
 */

/*
 * Copyright (c) 2002-2003, MAKISE Yoshitaro
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. Neither the name of the iModoki nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package jp.sourceforge.imodoki.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.BufferedInputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.ArrayList;
import java.lang.reflect.Method;
import java.lang.reflect.InvocationTargetException;

/**
 * Υޥ Java ץμ¹ԤΤΥ桼ƥƥ
 */
public class ExecUtils {
    private static boolean s_debug =
        System.getProperty("jp.sourceforge.imodoki.debug") != null;

    /**
     * Java ץ¹Ԥ롣
     *
     * @param  classPath  饹ѥnull ξϸߤ JVM 
     *                    饹ѥѤ롣
     * @param  className  饹̾
     * @param  args       
     * @param  fork       true ξ JVM 򿷤 fork 롣
     * @return ץΥ꥿󥳡ɡ
     *         fork==false ξˤϰ̣ʤʤ ( 0)
     *
     * @exception IOException
     *                    ¹Ԥ˥顼Ȥꤲ롣
     */
    public static int execJava(String classPath, String className,
                               String[] args, boolean fork)
        throws IOException {
        if (fork == true) {
            return execJavaFork(classPath, className, args);
        } else {
            return execJavaNoFork(classPath, className, args);
        }

    }

    private static int execJavaNoFork(String classPath, String className,
                                      String[] args) throws IOException {
        try {
            Class clazz;
            if (classPath != null) {
                ClassLoader loader = new ClassPathClassLoader(classPath);
                clazz = Class.forName(className, true, loader);
            } else {
                clazz = Class.forName(className);
            }
            Method mainMethod =
                clazz.getMethod("main", new Class[] { String[].class });
            mainMethod.invoke(null, new Object[] { args });
        } catch (ClassNotFoundException cnfe) {
            throw new IOException("Class not found: " + cnfe.toString());
        } catch (NoSuchMethodException nsme) {
            throw new IOException("Method not found: " + nsme.toString());
        } catch (IllegalAccessException iae) {
            throw new IOException("Illegal access: " + iae.toString());
        } catch (InvocationTargetException ite) {
            Throwable te = ite.getTargetException();
            if (s_debug) {
                te.printStackTrace();
            }
            throw new IOException("Exception occurred: " + te.toString());
        }

        return 0;
    }

    private static int execJavaFork(String classPath, String className,
                                    String[] args) throws IOException {
        List argsList = new ArrayList();
        argsList.add("java");
        argsList.add("-classpath");
        argsList.add(classPath);
        argsList.add(className);
        for (int i = 0; i < args.length; i++) {
            argsList.add(args[i]);
        }

        String[] cmdarray = (String[])argsList.toArray(new String[0]);
        return execCommand(cmdarray);
    }

    /**
     * ޥɤ¹Ԥ롣
     * ¹Ԥޤǥ֥å롣
     *
     * @param  cmdarray  ޥ̾Ȱ
     * @return ꥿󥳡ɡ
     *
     * @exception IOException
     *                    ¹Ԥ˥顼Ȥꤲ롣
     */
    public static int execCommand(String[] cmdarray) throws IOException {
        Process proc = Runtime.getRuntime().exec(cmdarray);

        InputStream in = proc.getInputStream();
        InputStream err = proc.getErrorStream();
        Thread inThread = new StreamRedirectionThread(in, System.out);
        Thread errThread = new StreamRedirectionThread(err, System.err);
        inThread.start();
        errThread.start();
        try {
            int exitCode = proc.waitFor();
            inThread.join();
            errThread.join();

            return exitCode;
        } catch (InterruptedException ie) {
            return 1;
        }
    }

    private static class StreamRedirectionThread extends Thread {
        private InputStream m_in;
        private PrintStream m_out;

        public StreamRedirectionThread(InputStream in, PrintStream out) {
            m_in = new BufferedInputStream(in);
            m_out = out;
        }

        public void run() {
            try {
                byte[] buf = new byte[4096];
                int len;

                while ((len = m_in.read(buf)) != -1)
                    m_out.write(buf, 0, len);
            } catch (IOException ioe) {
                System.err.println("Error: " + ioe);
                System.err.println("Continuing process...");
            }
        }
    }
}
