/*
 * $Id: JavaCompiler.java,v 1.3 2003/04/06 01:50:49 ymakise Exp $
 */

/*
 * Copyright (c) 2002-2003, MAKISE Yoshitaro
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. Neither the name of the iModoki nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package jp.sourceforge.imodoki.util;

import java.io.*;
import java.util.*;
import java.lang.reflect.Method;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

/**
 * Java ѥεưʤ륯饹
 */
public class JavaCompiler {
    private static boolean s_debug =
        System.getProperty("jp.sourceforge.imodoki.debug") != null;

    private File m_srcDir = null;
    private File m_destDir = null;
    private String m_bootClassPath = null;
    private String m_classPath = null;
    private boolean m_verbose = false;
    private boolean m_optimize = false;
    private boolean m_debug = false;
    private String m_target = null;
    private String m_encoding = null;

    /**
     * 󥹥ȥ饯
     */
    public void JavaCompiler() {
    }

    /**
     * Java ѥư롣
     * ǽǤ VM ͭ롣
     * եΥॹפåɬפʥե
     * ѥ뤹롣
     *
     * @return  ѥ true
     *
     * @exception IOException  ѥεư˼ԤȤ
     */
    public boolean compile() throws IOException {
        if (m_srcDir == null) {
            throw new IllegalStateException("srcDir not set");
        }

        if (m_destDir == null) {
            throw new IllegalStateException("destDir not set");
        }

        File[] srcFiles = FileUtils.listFilesRecursive(m_srcDir,
            new FileFilter() {
                public boolean accept(File file) {
                    if (file.isFile() && file.getName().endsWith(".java")) {
                        return true;
                    } else {
                        return false;
                    }
                }
            });

        // TODO: ɤȤ٤褦ˤ٤
        //       ޤɤ줬ưƤ뤫狼褦ˤ٤
        try {
            return invokeModernJavac(srcFiles);
        } catch (IOException ioe) {
            try {
                return invokeClassicJavac(srcFiles);
            } catch (IOException ioe2) {
                return invokeExternalJavac(srcFiles);
            }
        }
    }

    private boolean invokeModernJavac(File[] srcFiles) throws IOException {
        String[] args = getJavacArgs(srcFiles);

        String className = "com.sun.tools.javac.Main";

        try {
            /*
              new com.sun.tools.javac.Main().compile(args);
            */

            Class clazz = Class.forName(className);
            Method mthCompile =
                clazz.getMethod("compile", new Class[] { String[].class });
            Object objMain = clazz.newInstance();
            if (s_debug) {
                System.out.println("Invoking modern javac with args: " +
                                   Arrays.asList(args));
            }
            Integer result =
                (Integer)mthCompile.invoke(objMain, new Object[] { args });

            return result.intValue() == 0;
        } catch (ClassNotFoundException cnfe) {
            throw new IOException("Class not found: " + cnfe.toString());
        } catch (InvocationTargetException ite) {
            Throwable te = ite.getTargetException();
            te.printStackTrace();
            throw new IOException("Exception occurred: " + te.toString());
        } catch (Exception e) {
            /* NoSuchMethodException, IllegalAccessException,
               InstantiationException Τ줫 */
            throw new IOException(e.toString());
        }
    }

    private boolean invokeClassicJavac(File[] srcFiles) throws IOException {
        String[] args = getJavacArgs(srcFiles);

        String className = "sun.tools.javac.Main";

        try {
            /*
              new sun.tools.javac.Main(System.out, "javac").compile(args);
            */

            Class clazz = Class.forName(className);
            Constructor ctorMain = clazz.getConstructor(
                new Class[] { OutputStream.class, String.class });
            Method mthCompile =
                clazz.getMethod("compile", new Class[] { String[].class });
            Object objMain =
                ctorMain.newInstance(new Object[] { System.out, "javac" });
            if (s_debug) {
                System.out.println("Invoking classic javac with args: " +
                                   Arrays.asList(args));
            }
            Boolean result =
                (Boolean)mthCompile.invoke(objMain, new Object[] { args });

            return result.booleanValue();
        } catch (ClassNotFoundException cnfe) {
            throw new IOException("Class not found: " + cnfe.toString());
        } catch (InvocationTargetException ite) {
            Throwable te = ite.getTargetException();
            te.printStackTrace();
            throw new IOException("Exception occurred: " + te.toString());
        } catch (Exception e) {
            /* NoSuchMethodException, IllegalAccessException,
               InstantiationException Τ줫 */
            throw new IOException(e.toString());
        }
    }

    private boolean invokeExternalJavac(File[] srcFiles) throws IOException {
        String[] args = getJavacArgs(srcFiles);

        String[] cmdarray = new String[args.length + 1];
        System.arraycopy(args, 0, cmdarray, 1, args.length);
        cmdarray[0] = "javac";

        if (s_debug) {
            System.out.println("Invoking external javac with args: " +
                               Arrays.asList(args));
        }
        int exitCode = ExecUtils.execCommand(cmdarray);
        return (exitCode == 0);
    }

    private String[] getJavacArgs(File[] srcFiles) {
        List args = new ArrayList();

        if (m_verbose) {
            args.add("-verbose");
        }
        if (m_optimize) {
            args.add("-O");
        }
        if (m_debug) {
            args.add("-g");
        }
        if (m_target != null) {
            args.add("-target");
            args.add(m_target);
        }
        if (m_encoding != null) {
            args.add("-encoding");
            args.add(m_encoding);
        }
        if (m_bootClassPath != null) {
            args.add("-bootclasspath");
            args.add(m_bootClassPath);
        }
        if (m_classPath != null) {
            args.add("-classpath");
            args.add(m_classPath);
        }

        args.add("-d");
        args.add(m_destDir.getPath());

        for (int i = 0; i < srcFiles.length; i++) {
            args.add(srcFiles[i].getPath());
        }

        return (String[])args.toArray(new String[0]);
    }

    public void setSrcDir(File srcDir) {
        m_srcDir = srcDir;
    }

    public void setDestDir(File destDir) {
        m_destDir = destDir;
    }

    public void setBootClassPath(String path) {
        m_bootClassPath = path;
    }

    public void setClassPath(String path) {
        m_classPath = path;
    }

    public void setVerbose(boolean verbose) {
        m_verbose = verbose;
    }

    public void setOptimize(boolean optimize) {
        m_optimize = optimize;
    }

    public void setDebug(boolean debug) {
        m_debug = debug;
    }

    public void setTarget(String target) {
        m_target = target;
    }

    public void setEncoding(String encoding) {
        m_encoding = encoding;
    }
}
