/*
 * $Id: OptionParser.java,v 1.3 2003/04/06 01:50:49 ymakise Exp $
 */

/*
 * Copyright (c) 2002-2003, MAKISE Yoshitaro
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. Neither the name of the iModoki nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package jp.sourceforge.imodoki.util;

import java.io.PrintStream;
import java.util.*;

/**
 * ȤϤʤޥɥ饤󥪥ץѡ
 *
 * <p>äƤ뤳:</p>
 * <ul>
 *   <li>ꥪץξ˰
 *   <li>̤ץ򥨥顼ˤ
 *   <li>usage ɽ
 * </ul>
 *
 * <p>äƤʤ:</p>
 * <ul>
 *   <li>ץɬΥå
 *   <li>GNU  --hoge Τ褦 `--' β
 *   <li>GNU  --hoge=value Τ褦 `=' β
 *   <li>getopt  -ltrA Τ褦Ϣ뤵줿1ʸץβ
 *   <li>ηå䷿Ѵ
 * </ul>
 *
 * <p>:</p>
 *
 * <pre>
 *    OptionParser optParser = new OptionParser();
 *    optParser.addOption("-g");
 *    optParser.addOption("-o", true);
 *    optParser.addOption(.....);
 *    try {
 *        String opt;
 *        while ((opt = optParser.parse(args)) != null) {
 *            if (opt.equals("-g")) {
 *               .....
 *            } else if (opt.equals("-o")) {
 *               String arg = opt.getOptionArg();
 *            } else if (opt.equals("-hoge")) {
 *               .....
 *            }
 *        }
 *    } catch (OptionParserException ope) {
 *        System.err.println(ope.getMessage());
 *        System.exit(1);
 *    }
 *    String[] args = opt.getArgs();
 *    .....
 * </pre>
 */
public class OptionParser {
    /** ץƬ */
    private static final String OPTION_PREFIX = "-";

    /** ʤΥץǤ뤳Ȥ򼨤 */
    private static final String NO_ARG = "NO_ARG";

    private List m_args;
    private Map m_options;
    private List m_descriptions;
    private String[] m_parsingArgs;
    private int m_parsingIndex;
    private String m_optionArg;

    public OptionParser() {
        m_args = new ArrayList();
        m_options = new HashMap();
        m_descriptions = new ArrayList();
        m_parsingArgs = null;
        m_parsingIndex = 0;
    }

    /**
     * ץϿ롣
     *
     * @param  option   ץ̾: "-g" "-hoge"
     * @param  argSpec  ɽʸ: "<n>" "<filename>"
     *                  Υץ󤬰ʤʤ null
     * @param  desc     Υץ
     *                  '\n' 뤳ȤˤäƲԤǽ
     */
    public void addOption(String option, String argSpec, String desc) {
        if (argSpec == null)
            argSpec = NO_ARG;
        m_options.put(option, argSpec);
        m_descriptions.add(option);
        m_descriptions.add(desc);
    }

    public void addOption(String option, String desc) {
        addOption(option, null, desc);
    }

    /**
     * Ϥ롣
     * ƤӽФӤˡץҤȤļƤ֤
     * ץ󤬤ʤʤȡnull ֤
     * Ϥ args ͤ null ̤ͤѤȡ
     * Ϥǽ餫ľ
     *
     * @param  args  ޥɥ饤
     *
     * @param  OptionParserException
     *             ΥץˡͿʤäȤ
     *             ޤϡ̤ץΤȤ
     */
    public String parse(String[] args) throws OptionParserException {
        if (m_parsingArgs == null ||
            (args != null && args != m_parsingArgs)) {
            resetParsing(args);
        }

        while (m_parsingIndex < m_parsingArgs.length) {
            String elem = m_parsingArgs[m_parsingIndex++];

            if (elem.startsWith(OPTION_PREFIX)) {
                /* ץ */
                Object value = m_options.get(elem);
                if (value != null) {
                    if (value != NO_ARG) {
                        if (m_parsingIndex >= m_parsingArgs.length) {
                            throw new OptionParserException(
                                "Missing argument: " + elem);
                        }
                        m_optionArg = m_parsingArgs[m_parsingIndex++];
                        return elem;
                    } else {
                        m_optionArg = null;
                        return elem;
                    }
                } else {
                    throw new OptionParserException("Unrecognized option: " +
                                                    elem);
                }
            } else {
                /*  */
                m_args.add(elem);
            }
        }

        return null;
    }

    private void resetParsing(String[] args) {
        m_parsingArgs = args;
        m_parsingIndex = 0;
    }

    /**
     * ꥪץΡ֤
     *
     * @return ץ
     */
    public String getOptionArg() {
        return m_optionArg;
    }

    /**
     * ץʳΰ֤
     * parse(String[])  null ֤ǤƤ֤ȤǤʤ
     *
     */
    public String[] getArgs() {
        if (m_parsingIndex < m_parsingArgs.length) {
            throw new IllegalStateException("Parsing not completed");
        }

        return (String[])m_args.toArray(new String[0]);
    }

    /**
     * usage ɽ롣
     *
     * @param  out  ϥȥ꡼ࡣ
     * @param  optIndent   ץɽ֤Υǥȡ
     * @param  descIndent  ɽ֤Υǥȡ
     */
    public void printUsage(PrintStream out, int optIndent, int descIndent) {
        int minGap = 2;

        StringBuffer line = new StringBuffer();

        Iterator itr = m_descriptions.iterator();
        while (itr.hasNext()) {
            String option = (String)itr.next();
            String desc = (String)itr.next();
            String arg = (String)m_options.get(option);

            line.setLength(0);

            line.append(StringUtils.nspace(optIndent));
            if (arg != NO_ARG) {
                line.append(option);
                line.append(' ');
                line.append(arg);
            } else {
                line.append(option);
            }

            if (line.length() + minGap <= descIndent) {
                /* ץƱԤ˽ */
                int gap = descIndent - line.length();
                line.append(StringUtils.nspace(gap));
                out.print(line.toString());
                StringTokenizer st = new StringTokenizer(desc, "\n");
                out.println(st.nextToken());
                while (st.hasMoreTokens()) {
                    out.print(StringUtils.nspace(descIndent));
                    out.println(st.nextToken());
                }
            } else {
                /* ץñȤǽϡϼι԰ʹ */
                out.println(line.toString());
                StringTokenizer st = new StringTokenizer(desc, "\n");
                while (st.hasMoreTokens()) {
                    out.print(StringUtils.nspace(descIndent));
                    out.println(st.nextToken());
                }
            }
        }
    }
}
