#!/usr/local/bin/ruby

# essi.rb version 0.40, written by Y.Makise
#
# :
#
#   SSI Τ褦ʤȤ HTML եľܽ񤭴Ǽ¸ץࡣ
#   ESSI:  Server Side Include :-)
#
# :
#
#   essi.rb [options] files...
#   options:
#     -b suff, --suffix suff
#         ХååץեγĥҤꤹ롣ǥեȤǤ
#         "~"-b "" ʤɤȻꤹȥХååץե
#         
#     -v, --verbose
#         Ĺʽϡ
#
# ˡ:
#
#   㤨лեդȤˤϡHTMLե
#   Ȥ
#       <!--@flastmod file="hoge.html"--><!--@flastmod end-->
#   ʤɤȵ롣hoge.html ΤȤդեΥѥ
#   СХǥ쥯ȥ꤬Ȥ롣
#
#   ơդ򹹿ˡ
#   % essi.rb index.html fuga.html ...
#   Ȥȡindex.html  fuga.html ξҤΥ񤭴롣
#   Ĥޤꡢ2ĤΥδ֤ˡꤵ줿դ롣
#
#   ʤΤȤХååץե뤬롣Хååץե
#   γĥҤϥǥեȤǤ "~" ץѤ롣
#
#   2ܰʹߤϡessi.rb ¹Ԥ뤿Ӥˡδ֤줿դ
#   Ƥפϡδ֤˲ʸ󤬤ä餽äƤ
#   դƤ롣Τᡢ٥񤭹餢Ȥϥե
#   򹹿뤿ӤŬ essi.rb ¹ԤǤ褤
#
# :
#
#   <!--@flastmod file="xxx.html"--><!--@flastmod end-->
#       եι
#   <!--@fsize file="xxx.html"--><!--@fsize end-->
#       եΥե륵
#   <!--@exec cmd="command"--><!--@exec end-->
#       ޥɤμ¹Է̤
#   <!--@include file="xxx.html"--><!--@include end-->
#       եƤ
#   <!--@config timefmt="xxxxx"-->
#       flastmod ΥեޥåȤꤹ롣եޥåȤ
#       strftime(3) ˽
#   <!--@config sizefmt="bytes|abbrev"-->
#       fsize ΥեޥåȤꤹ롣"bytes"  "abbrev"
#
# :
#
#   * 顼ʤƤʤ櫓ʤ ruby ޤˤƤ
#     ʬ빽롣ΤΤ顼åФƤ⤽Ϥ
#     ץȤΥХǤϤʤե˽񤭹ʤȤ
#     Ūʥ顼Ǥ뤳Ȥ¿
#
# ѹ:
#
#   version	comment
#    0.20	* 顼ΥɤʸˡŪʥߥäΤ(
#		  ȤƤʤä)
#		* 2٥ʾ symlink бƤʤäΤ
#		* 顼ɽκݡΤäɽ褦ˤ
#		  ޤֹɽ褦ˤ
#		* ޥå󥰥롼ľݼ餷䤹Τˤ
#		  ¿Υԡɥåפ⸫뤫⡣
#		* -v ץդ
#
#    0.21	* EXEC cmd ǥ쥯ƥ֤Υݡȡ
#		*  symlink бƤʤäΤ
#
#    0.30	* ǥ쥯ƥ֤ <!--@flastmod  ʤɤΤ褦
#		  ̾Ƭ @ Ĥ褦ˤ
#		* ץ˽񤭴ĥ˭ˤ
#    0.40       * include ǥ쥯ƥ֤Υݡȡ
#
# 
#   * include νϡͥȤȤΥŸ⡣
#     ȤޥƥϤɤΤǤ٤
#   * HTMLեʸɤ SJIS  JIS äˤϲ褫
#     Ȥʤ̤ SSI ǤäнϤƤʤ
#     ɡ
#   * exec ϴʥޥɤǡΥ¤ۤ
#     褤⡣


# ǥեȤդΥեޥå
DEFAULT_TIMEFMT = "%A, %d-%b-%Y %H:%M:%S %Z"
# ХååץեγĥҤΥǥե
DEFAULT_BACKUP_SUFFIX = '~'

require 'getopts'
require 'cgi-lib'

def verbose(fmt, *arg)
  if $verbose
    $stdout.printf(fmt, *arg)
    $stdout.print "\n"
  end
end

class ESSISyntaxError < StandardError
end

class Config
  def initialize(basedir)
    @basedir = basedir
    @timefmt = DEFAULT_TIMEFMT
    @sizefmt = :ABBREV
  end

  attr_reader :basedir
  attr_accessor :timefmt
  attr_accessor :sizefmt
end

class DirectiveHandler
  def requires_end?; raise 'Override me!'; end
  def content; raise 'Override me!'; end
  def process; raise 'Override me!'; end

  def require_attr(name)
    if instance_eval('@' + name) == nil
      raise ESSISyntaxError.new(name + ' attribute is required')
    end
  end
end

class FlastmodHandler < DirectiveHandler
  def initialize(config)
    @config = config
  end

  def requires_end?; true; end

  def file=(file)
    @file = file
  end

  def content
    require_attr('file')

    path = File.expand_path(@file, @config.basedir)
    verbose("Getting mtime of %s", path)
    begin
      mtime = File.mtime(path)
      cont = mtime.strftime(@config.timefmt)
      CGI.escapeHTML(cont)
    rescue Errno::ENOENT
      raise ESSISyntaxError.new($!)
    end
  end
end

class FsizeHandler < DirectiveHandler
  def initialize(config)
    @config = config
  end

  def requires_end?; true; end

  def file=(file)
    @file = file
  end

  def content
    require_attr('file')

    path = File.expand_path(@file, @config.basedir)
    verbose("Getting size of %s", path)
    begin
      size = File.size(path)
      cont = size_to_s(size, @config.sizefmt)
      CGI.escapeHTML(cont)
    rescue Errno::ENOENT
      raise ESSISyntaxError.new($!)
    end
  end

  # SSI fsize ɽ ; : Apache Υ
  def size_to_s(size, fmt)
    if fmt == :ABBREV
      if size == 0
	'0k'
      elsif size < 1024
	'1k'
      elsif size < 1048576		# 1024*1024
	sprintf('%dk', (size+512)/1024)
      elsif size < 99*1048576		# 99*1024*1024
	sprintf('%.1fM', size/1048576.0)
      else
	sprintf('%dM', (size+524288)/1048576)
      end
    else
      s = size.to_s
      while s.sub!(/([^,])(\d\d\d)\b/, "\\1,\\2") ; end
      s
    end
  end
  private :size_to_s
end

class ExecHandler < DirectiveHandler
  def initialize(config)
    @config = config
  end

  def requires_end?; true; end

  def cmd=(cmd)
    @cmd = cmd
  end

  def content
    require_attr('cmd')

    verbose("Invoking command \"%s\"", @cmd)
    if cmd == '-'
      raise ESSISyntaxError.new("Cannot fork myself")
    end
    begin
      cont = nil
      with_chdir(@config.basedir) do
	fp = IO.popen(cmd)
	cont = fp.read || ''
	fp.close
      end
      CGI.escapeHTML(cont)
    rescue
      # ޥɤμ¹Ԥ˼ԤƤ⤳ˤʤ(ΤǤޤ̣Ϥʤ)
      raise ESSISyntaxError.new($!)
    end
  end

  # Ruby 1.7 ʹߤǤ Dir.chdir {} Ǽ¸ǽ
  def with_chdir(dir, &block)
    savedir = Dir.pwd
    Dir.chdir(dir)
    begin
      return block.call
    ensure
      Dir.chdir(savedir)
    end
  end
  private :with_chdir
end

class IncludeHandler < DirectiveHandler
  def initialize(config)
    @config = config
  end

  def requires_end?; true; end

  def file=(file)
    @file = file
  end

  def content
    require_attr('file')

    path = File.expand_path(@file, @config.basedir)
    verbose("Including contents of %s", path)
    begin
      fp = File.open(path)
      cont = fp.read || ''
      fp.close
      "\n" + cont
    rescue Errno::ENOENT
      raise ESSISyntaxError.new($!)
    end
  end
end

class ConfigHandler < DirectiveHandler
  def initialize(config)
    @config = config
  end

  def requires_end?; false; end

  def timefmt=(fmt)
    @timefmt = fmt
  end

  def sizefmt=(fmt)
    case fmt.downcase
    when 'bytes'
      @sizefmt = :BYTES
    when 'abbrev'
      @sizefmt = :ABBREV
    else
      raise ESSISyntaxError.new(format("unknown sizefmt parameter \"%s\"", str))
    end
  end

  def process
    if @timefmt == nil && @sizefmt == nil
      raise ESSISyntaxError.new('timefmt or sizefmt attribute is required')
    end

    @config.timefmt = @timefmt  if @timefmt != nil
    @config.sizefmt = @sizefmt  if @sizefmt != nil
  end
end

class ESSI
  # ʸ˥ޥåɽ(Υ)
  RE_STR_CONTENT = /(?:[^"\\]|\\.)*/.source  #"
  RE_NAME = '\w+'
  RE_ATTR = "#{RE_NAME}=\"#{RE_STR_CONTENT}\""
  RE_CONTENT = '(?:\r|\n|.)*?'
  RE_DIRECTIVE = /(<!--@\s*(#{RE_NAME})\s*((?:#{RE_ATTR}\s*)*)\s*-->)(?:(#{RE_CONTENT})(<!--@\s*\2\s*end\s*-->))?/oi

  #   : text    : ƥȡʥեƤޤ뤴ȡ
  #       : basedir : text γƥޥɤΥեѥδǥ쥯ȥ
  #       : fname   : Ƥե̾ (顼ɽ)
  def initialize(text, basedir, fname)
    @text = text
    @config = Config.new(basedir)
    @fname = fname
    @match_begin = -1

    @handlers = {
      'flastmod' => FlastmodHandler.new(@config),
      'fsize'    => FsizeHandler.new(@config),
      'exec'     => ExecHandler.new(@config),
      'include'  => IncludeHandler.new(@config),
      'config'   => ConfigHandler.new(@config)
    }
  end

  # ESSI 
  # : ƥƤѹäˤϽʸ
  #         ʤ nil
  def process
    changed = false

    result = @text.gsub(RE_DIRECTIVE) do
      match = $&
      verbose("Found directive: %s", match)
      @match_begin = $~.begin(0)
      start_tag, elem, attrs, old_cont, end_tag =
          $1, $2.downcase, get_attrs($3), $4, $5

      begin
	handler = @handlers[elem]
	if handler == nil
	  raise ESSISyntaxError.new('unknown element: ' + elem)
	end
	if handler.requires_end? && end_tag == nil
	  raise ESSISyntaxError.new('end tag required')
	end

	set_handler_attrs(handler, attrs)
	if handler.requires_end?
	  cont = handler.content
	  changed = true  if cont != old_cont
	  # return value
	  start_tag + cont + end_tag
	else
	  handler.process
	  # return value
	  start_tag
	end
      rescue ESSISyntaxError
	error_line($!.to_s, match)
	return nil
      end
    end

    return nil  if !changed
    result
  end

  # 'hoge="fuga" aaa="bbb" ...' Ȥ attrs  Hash 
  def get_attrs(src)
    result = {}
    src.scan(/(#{RE_NAME})="(#{RE_STR_CONTENT})"/) do |name,value|
      name.downcase!
      value.gsub!(/\\"/, "\"")
      result[name] = value
    end
    result
  end

  # attrs 򸫤 handler Υץѥƥ򥻥åȤ
  def set_handler_attrs(handler, attrs)
    attrs.each_pair do |name, value|
      begin
	handler.method(name + '=').call(value)
      rescue NameError
	raise ESSISyntaxError.new('unexpected attribute: ' + name)
      end
    end
  end

  # ֹդ顼ɽ
  def error_line(msg, match)
    $stderr.print("#{@fname}:#{count_lines(@text[0, @match_begin])+1}: ")
    $stderr.print(msg, "\n")
    $stderr.print('  ', match, "\n")
  end

  # ʸβԤο롣
  def count_lines(str)
    cnt = 0
    str.scan(/\n/) { cnt += 1 }
    cnt
  end
end


def usage
  $stdout.print <<"__EOF__"
usage: #{$0} [options] files...
options:
  -b suff, --suffix=suff
      Specify suffix of the backup file. default is "~". Giving
      -b "" means makes no backup file.
  -v, --verbose
      Enable verbose output.
__EOF__
end


# ᥤ

r = getopts('v', 'b:', 'suffix:', 'verbose', 'help')
if r == nil
  usage
  exit 1
end

if $OPT_help
  usage
  exit 0
end  

if ARGV.length < 1
  usage
  exit 1
end

backup_suffix = $OPT_b || $OPT_suffix || DEFAULT_BACKUP_SUFFIX
$verbose = $OPT_v || $OPT_verbose

exitcode = 0
ARGV.each do |fname|
  begin
    verbose("Opening file: %s", fname)
    fr = File.open(fname, 'r')
  rescue Errno::ENOENT
    $stderr.print $0, ': File not found: ', fname, "\n"
    exitcode = 1
    next
  end
  st = fr.stat
  text = fr.read
  fr.close

  result = (ESSI.new(text, File.dirname(fname), fname)).process

  if result != nil
    $stdout.printf("Updating: %s\n", fname)
    # ѹäΤǽ񤭽Ф
    if backup_suffix != ''
      while FileTest.symlink?(fname)
	fname = File.expand_path(File.readlink(fname), File.dirname(fname))
      end
      verbose("Renaming file %s to %s", fname, fname + backup_suffix)
      File.rename(fname, fname + backup_suffix)
    end
    verbose("Opening file for write: %s", fname)
    fw = File.open(fname, 'w')
    begin
      fw.chmod(st.mode)
    rescue
    end
    fw.write(result)
    fw.close
  end
end

exit exitcode
