/*
 * $Id: ClassPattern.java,v 1.2 2003/04/06 01:50:48 ymakise Exp $
 */

/*
 * Copyright (c) 2002-2003, MAKISE Yoshitaro
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. Neither the name of the iModoki nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package jp.sourceforge.imodoki.extractor;

import java.util.List;
import java.util.ArrayList;
import java.util.Set;
import java.util.HashSet;
import java.util.Iterator;

/**
 * 饹Υѥ
 */
public class ClassPattern {
    private List m_packagePattern;
    private Set m_classPattern;

    /**
     * 󥹥ȥ饯
     */
    public ClassPattern() {
        m_packagePattern = new ArrayList();
        m_classPattern = new HashSet();
    }

    /**
     * ΥѥåȤΥ֥ѥå˥ޥåѥɲä롣
     *
     * @param  name  ѥåꤹʸ
     *               : "java.lang" 
     */
    public void addPackagePattern(String name) {
        if (!name.endsWith(".")) {
            name = name + ".";
        }
        m_packagePattern.add(name);
        m_packagePattern.add(name.replace('.', '/'));
    }

    /**
     * 饹̾˥ޥåѥɲä롣
     *
     * @param  name  fully qualified 饹̾
     */
    public void addClassPattern(String name) {
        m_classPattern.add(name);
        m_classPattern.add(name.replace('.', '/'));
    }

    /**
     * 륯饹ѥ˥ޥå뤫ɤĴ٤롣
     *
     * @param  name  fully qualified ʥ饹̾
     * @return ޥå true
     */
    public boolean matches(String name) {
        if (m_classPattern.contains(name)) {
            return true;
        }

        Iterator itr = m_packagePattern.iterator();
        while (itr.hasNext()) {
            String pattern = (String)itr.next();
            if (name.startsWith(pattern)) {
                return true;
            }
        }

        return false;
    }
}
