/*
 * $Id: ClassUtils.java,v 1.3 2003/04/06 01:50:48 ymakise Exp $
 */

/*
 * Copyright (c) 2002-2003, MAKISE Yoshitaro
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. Neither the name of the iModoki nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package jp.sourceforge.imodoki.extractor;

import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.AccessFlags;

/**
 * 饹桼ƥƥ᥽åɤνޤꡣ
 */
class ClassUtils {
    /**
     * ᥽åɤΥͥʸ롣
     * "(ꥹ)" ηˤ롣
     */
    public static String canonicalizeMethodSignature(String signature) {
        if (signature.length() == 0 || signature.charAt(0) != '(') {
            return "(" + signature + ")";
        } else {
            int idx = signature.indexOf(')');
            if (idx == -1) {
                return signature;
            } else {
                return signature.substring(0, idx + 1);
            }
        }
    }

    /**
     * եɤΥͥʸ󤫤顢֥ȤʬФ
     * ξϡΥݡͥʬ֤
     * ֥ȤǤʤ null ֤
     * 򸫤ۤᤤ(Ȥɤ򸫤ۤᤤ)
     *
     * : "[[Ljava/lang/String;"  "java.lang.String"
     *     "Ljava.awt.Point;"      "java.awt.Point"
     *     "[[[I"                  null
     *     "Z"                     null
     */
    public static String getComponentObject(String signature) {
        int len = signature.length();

        for (int i = 0; i < len; i++) {
            char c = signature.charAt(i);
            if (c == 'L') {
                int idx = signature.indexOf(';', i + 1);
                return signature.substring(i + 1, idx).replace('/', '.');
            } else if (c == '[') {
                continue;
            } else {
                return null;
            }
        }

        throw new RuntimeException("Bad signature");
    }
}
