/*
 * $Id: Mark.java,v 1.4 2003/04/06 01:50:48 ymakise Exp $
 */

/*
 * Copyright (c) 2002-2003, MAKISE Yoshitaro
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. Neither the name of the iModoki nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package jp.sourceforge.imodoki.extractor;

import java.util.Map;
import java.util.HashMap;
import java.util.Set;
import java.util.HashSet;

/**
 * ᥽åɤեɤ˥ޡĤ롣
 */
public class Mark {
    private Map m_map;

    /**
     * 󥹥ȥ饯
     */
    public Mark() {
        m_map = new HashMap();
    }

    /**
     * ꤵ줿᥽åɤ֥ޡ줿פΤȤưĤ롣
     *
     * @param  className  饹̾
     * @param  name       ᥽å̾
     * @param  signature  Υͥ㡣
     *                    "(ꥹ)֤" ηǤ⡢
     *                    "(ꥹ)" ηǤ⡢
     *                    "ꥹ" ηǤ褤
     */
    public void setMethodMarked(String className,
                                 String name, String signature) {
        className = className.replace('/', '.');
        signature = ClassUtils.canonicalizeMethodSignature(signature);
        addMark(className, name + signature);
    }

    /**
     * ꤵ줿եɤ֥ޡ줿פΤȤưĤ롣
     *
     * @param  className  饹̾
     * @param  name       ե̾
     */
    public void setFieldMarked(String className, String name) {
        className = className.replace('/', '.');
        addMark(className, name);
    }

    /**
     * ꤵ줿᥽åɤޡƤ뤫ɤĴ٤롣
     *
     * @param  className  饹̾
     * @param  name       ᥽å̾
     * @param  signature  Υͥ㡣
     *                    "(ꥹ)֤" ηǤ⡢
     *                    "(ꥹ)" ηǤ⡢
     *                    "ꥹ" ηǤ褤
     * @return ޡƤ true
     */
    public boolean isMethodMarked(String className, String name,
                                  String signature) {
        className = className.replace('/', '.');
        signature = ClassUtils.canonicalizeMethodSignature(signature);
        return isMarked(className, name + signature);
    }

    /**
     * ꤵ줿եɤޡƤ뤫ɤĴ٤롣
     *
     * @return ޡƤ true
     */
    public boolean isFieldMarked(String className, String name) {
        className = className.replace('/', '.');
        return isMarked(className, name);
    }


    /**
     * ޡ򥯥ꥢ롣
     */
    public void clear() {
        m_map.clear();
    }

    private void addMark(String className, String key) {
        Set mark = (Set)m_map.get(className);
        if (mark == null) {
            mark = new HashSet();
            m_map.put(className, mark);
        }
        mark.add(key);
    }

    private boolean isMarked(String className, String key) {
        Set mark = (Set)m_map.get(className);
        if (mark == null) {
            return false;
        } else {
            return mark.contains(key);
        }
    }
}
