/*
 * $Id: Repository.java,v 1.4 2003/04/06 01:50:48 ymakise Exp $
 */

/*
 * Copyright (c) 2002-2003, MAKISE Yoshitaro
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. Neither the name of the iModoki nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package jp.sourceforge.imodoki.extractor;

import java.util.Map;
import java.util.HashMap;
import java.io.InputStream;
import java.io.IOException;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.ClassParser;
import jp.sourceforge.imodoki.extractor.ClassPath;

/**
 * 饹եΥݥȥꡣ
 * ãǽʥ饹ξݻ롣
 */
public class Repository {
    private ClassPath m_classPath;
    private Map m_classes;

    /**
     * 󥹥ȥ饯
     *
     * @param  classPath  ץåȥե¸Υ饹ѥ
     */
    public Repository(String classPath) {
        m_classPath = new ClassPath(classPath);
        m_classes = new HashMap();
    }

    /**
     * 饹̾ JavaClass ֥Ȥ롣
     *
     * @exception  IOException  饹ĤʤȤ
     *                          ϡեɤ߹˥顼
     *                          ȯȤ
     */
    public JavaClass lookupClass(String name) throws IOException {
        name = name.replace('/', '.');

        JavaClass cls = (JavaClass)m_classes.get(name);
        if (cls == null) {
            InputStream is = m_classPath.getInputStream(name);
            ClassParser parser = new ClassParser(is, name);
            cls = parser.parse();
            m_classes.put(name, cls);
        }

        return cls;
    }

    /**
     * ݻƤƤ JavaClass ֥ȤؤλȤ
     * ֤
     */
    public JavaClass[] getClasses() {
        JavaClass[] classes =
            (JavaClass[])m_classes.values().toArray(new JavaClass[0]);
        return classes;
    }

    /** ݥȥˤ롣 */
    public void clear() {
        m_classes.clear();
    }

    /** ѥ꥽롣 */
    public void close() {
        try {
            m_classPath.close();
        } catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}
