import java.io.File;
import junit.framework.TestCase;
import jp.sourceforge.imodoki.extractor.ClassPattern;
import jp.sourceforge.imodoki.extractor.Repository;
import jp.sourceforge.imodoki.extractor.Mark;
import jp.sourceforge.imodoki.extractor.Marker;

public class AllTest extends TestCase {
    private Repository m_repository;
    private Mark m_mark;
    private Marker m_marker;

    public AllTest(String name) {
        super(name);
    }

    private void init(String pkg) {
        String classPath = System.getProperty("sun.boot.class.path") +
            File.pathSeparator + System.getProperty("java.class.path");
        m_repository = new Repository(classPath);
        m_mark = new Mark();
        ClassPattern includePat = new ClassPattern();
        includePat.addPackagePattern(pkg);
        m_marker = new Marker(m_repository, includePat, m_mark);
    }

    private boolean isMarked(String sig) {
        int idx = sig.lastIndexOf('.');
        String clazz = sig.substring(0, idx);
        int idx2 = sig.indexOf('(');
        if (idx2 != -1) {
            String name = sig.substring(idx + 1, idx2);
            String args = sig.substring(idx2);
            return m_mark.isMethodMarked(clazz, name, args);
        } else {
            String name = sig.substring(idx + 1);
            return m_mark.isFieldMarked(clazz, name);
        }
    }

    /** Test 1: implicit abstract (with included interface) */
    public void test1() throws Exception {
        init("test1");
        m_marker.preserveMethod("test1.Test",
                                "main", "([Ljava/lang/String;)");
        m_marker.postProcess();

        assertTrue(isMarked("test1.Test.main([Ljava/lang/String;)"));
        assertTrue(isMarked("test1.Test.hello()"));
        assertTrue(isMarked("test1.Super.sayHello()"));
    }

    /** Test 2: implicit abstract (with excluded interface) */
    public void test2() throws Exception {
        init("test2");
        m_marker.preserveMethod("test2.Test",
                                "main", "([Ljava/lang/String;)");
        m_marker.postProcess();

        assertTrue(isMarked("test2.Test.main([Ljava/lang/String;)"));
        assertTrue(isMarked("test2.Test.run()"));
        assertTrue(isMarked("test2.Super.sayHello()"));
    }
}
