/*
 * $Id: ShortTimer.java,v 1.3 2003/04/06 01:50:47 ymakise Exp $
 */

/*
 * ΥեΥ饤󥹤ϰʲΤ褦 BSD 饤󥹤˽򤷤ޤ
 * 㳰ȤơiɤѴġˤäѴ줿Ѵ
 *  MIDP ץꥱղä줿󥿥饤֥ΥХʥ
 * ˤĤƤϡiɤԤϤʤ븢ĥʤΤȤޤ
 *
 * Copyright (c) 2002-2003, MAKISE Yoshitaro
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. Neither the name of the iModoki nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.nttdocomo.ui;

import com.nttdocomo.util.TimeKeeper;

/*
  TODO:
   - ե졼बڤؤȥޤߤʤȤʤ
 */

public final class ShortTimer implements TimeKeeper {
    private static final int RESOLUTION = 100;

    private Canvas m_canvas;
    private int m_time;
    private boolean m_repeat;

    private ShortTimerHelperTask m_task;
    private boolean m_started;

    private ShortTimer(Canvas canvas, int id, int time, boolean repeat) {
        m_canvas = canvas;
        m_time = time;
        m_repeat = repeat;
        m_task = new ShortTimerHelperTask(canvas, id, this);
        m_started = false;
    }

    public static ShortTimer getShortTimer(Canvas canvas, int id,
                                           int time, boolean repeat) {
        return new ShortTimer(canvas, id, time, repeat);
    }

    public int getResolution() {
        // äβ٤֤
        return RESOLUTION;
    }

    public void start() {
        if (m_started || m_task == null)
            throw new UIException(UIException.ILLEGAL_STATE);

        if (Display.getCurrent() != m_canvas)
            return;

        java.util.Timer timer = m_canvas.getMIDPTimer();
        if (m_repeat) {
            timer.schedule(m_task, m_time, m_time);
        } else {
            timer.schedule(m_task, m_time);
        }
        m_started = true;
    }

    /* ShortTimerHelperTask ƤФ */
    void timerExpired() {
        if (!m_repeat) {
            m_started = false;
        }
    }

    public void stop() {
        if (m_task == null)
            throw new UIException(UIException.ILLEGAL_STATE);

        m_task.cancel();
        m_started = false;
    }

    public void dispose() {
        m_task.cancel();
        m_task = null;
        m_started = false;
    }
}
