/*
 * $Id: MainMIDlet.java,v 1.3 2003/04/06 01:50:46 ymakise Exp $
 */

/*
 * ΥեΥ饤󥹤ϰʲΤ褦 BSD 饤󥹤˽򤷤ޤ
 * 㳰ȤơiɤѴġˤäѴ줿Ѵ
 *  MIDP ץꥱղä줿󥿥饤֥ΥХʥ
 * ˤĤƤϡiɤԤϤʤ븢ĥʤΤȤޤ
 *
 * Copyright (c) 2002-2003, MAKISE Yoshitaro
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. Neither the name of the iModoki nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package imodoki;

import javax.microedition.midlet.MIDlet;
import com.nttdocomo.ui.IApplication;
import imodoki.util.StringTokenizer;

/** MIDlet Υȥݥ */
public final class MainMIDlet extends MIDlet implements Runnable {
    /* com.nttdocomo.ui.IApplication 黲Ȥ */
    public static String[] s_appArgs;
    public static String s_sourceURL;
    /* imodoki.wrapper.ScratchPadInputStream 黲Ȥ */
    public static int s_midletDataSize;

    private static MainMIDlet s_instance;

    private IApplication m_currentApp;
    private boolean m_started;
    private javax.microedition.lcdui.Display m_display;

    public MainMIDlet() {
        s_instance = this;
        m_started = false;

        s_appArgs = splitArgs(getAppProperty("IMDK-AppParam"));
        s_sourceURL = getAppProperty("IMDK-SourceURL");
        String s = getAppProperty("MIDlet-Data-Size");
        if (s != null) {
            s_midletDataSize = Integer.parseInt(s);
        }
    }

    public void startApp() {
        if (!m_started) {
            m_display = javax.microedition.lcdui.Display.getDisplay(this);
            com.nttdocomo.ui.Display.setMIDPDisplay(m_display);

            /* startApp() ˲ setCurrent() 
               ʤȥߥ졼ư䤷ʤ礬
               ΤǤؤн */
            m_display.setCurrent(com.nttdocomo.ui.Display.s_dummyCanvas);
        }

        new Thread(this).start();
    }

    /** IApplication#start()/resume() μ¹ԤΤΥå */
    public synchronized void run() {
        if (!m_started) {
            /* IAppStub ϥ饹̾ѴˤäƼºݤiץΥ饹̾
               ֤ */
            m_currentApp = new IAppStub();
            m_started = true;
            m_currentApp.start();
        } else {
            // TODO: 쥸塼।٥Ȥꤲ
            //       Ȼפä jguide010514.pdf ˤ RESUME_VM_EVENT 
            //       ѤʤȽ񤤤Ƥ롣API ȤɤäΤ
            m_currentApp.resume();
        }
    }

    public void pauseApp() {
        // do nothing
    }

    public void destroyApp(boolean unconditional) {
        // do nothing
    }

    /** IApplication ƤӽФ */
    public static void terminate() {
        s_instance.destroyApp(true);
        s_instance.notifyDestroyed();
    }

    /** Ƕڤ줿 param Ѵ */
    private static String[] splitArgs(String param) {
        if (param == null) {
            return new String[0];
        }

        StringTokenizer st = new StringTokenizer(param);
        String[] result = new String[st.countTokens()];
        for (int i = 0; i < result.length; i++) {
            result[i] = st.nextToken();
        }

        return result;
    }
}
