/*
 * $Id: StringTokenizer.java,v 1.3 2003/04/06 01:50:46 ymakise Exp $
 */

/*
 * ΥեΥ饤󥹤ϰʲΤ褦 BSD 饤󥹤˽򤷤ޤ
 * 㳰ȤơiɤѴġˤäѴ줿Ѵ
 *  MIDP ץꥱղä줿󥿥饤֥ΥХʥ
 * ˤĤƤϡiɤԤϤʤ븢ĥʤΤȤޤ
 *
 * Copyright (c) 2002-2003, MAKISE Yoshitaro
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. Neither the name of the iModoki nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package imodoki.util;

/**
 * java.util.StringTokenizer ʡ
 */
public class StringTokenizer {
    private String m_string;
    private String m_delims;
    private int m_pos;
    private int m_length;

    public StringTokenizer(String string, String delims) {
        m_string = string;
        m_delims = delims;
        m_length = string.length();
    }

    public StringTokenizer(String str) {
        this(str, " \t");
    }

//     public boolean hasMoreTokens() {
//     }

    /**
     * java.util.StringTokenizer#nextToken() Ʊͤư򤹤롣
     * ȡ󤬿Ԥˤ NoSuchElementException
     * ꤲΤǤϤʤ null ֤
     * (Τۤ饹եΥǤΤǡ)
     */
    public String nextToken() {
        /* Skip spaces */
        int start = m_pos;
        while (start < m_length &&
               m_delims.indexOf(m_string.charAt(start)) != -1) {
            start++;
        }

        if (start == m_length) {
            return null;
        }

        /* Skip non-spaces */
        int end = start + 1;
        while (end < m_length &&
               m_delims.indexOf(m_string.charAt(end)) == -1) {
            end++;
        }

        m_pos = end;

        return m_string.substring(start, end);
    }

    /**
     * java.util.StringTokenizer#countTokens() Ʊͤư򤹤롣
     */
    public int countTokens() {
        int cnt = 0, save = m_pos;

        while (nextToken() != null) {
            cnt++;
        }
        m_pos = save;

        return cnt;
    }

//     public static void main(String[] args) {
//         String str = "  ab       cde  fgh  ";
//         StringTokenizer st = new StringTokenizer(str);
//         String s;
//         while ((s = st.nextToken()) != null) {
//             System.out.println("'" + s + "'");
//         }
//     }
}
