/*
 * Copyright (c) 2003, Influenza. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
import java.io.*;

/**
 * BPEfR[_(Xg[)
 *
 * +0 [ ubNTCY(b7-b0)  ] +ubNf[^̃TCY
 * +1 [ ubNTCY(b15-b8) ]
 * +2` oCgyA
 *      0-127   f[^n̃oCgyAGg܂
 *              eł邱ƂB
 *              f[^GgԍƓȂ烊eA
 *              قȂ΃oCgyAleftȂ̂Ŏ̃f[^̓oCgyArightɂȂ
 *      128-255 XLbv (n - 127)̘A郊e 
 *              ̒1̃oCgyAGg܂̓e
 *              
 * +??` ubNf[^
 */
public class BPEInputStream extends InputStream {
    InputStream in;
    int[] dict;
    byte[] block;
    int pos;
    int len;
    int[] stack;
    int sp;

    /**
     * obt@mۂ
     * @param in eXg[
     */
    public BPEInputStream( InputStream in ) throws IOException {
        this.in = in;
        dict = new int[256];
        stack = new int[32];
        block = new byte[4096];
        len = 0;
    }

    /**
     * 1oCgǂݏo
     * @see read(byte[], int, int) ł΂gׂ
     */
    public int read() throws IOException {
        int i0 = read( block, 0, 1 ); // block[0]͎Ȃ̂ŖȂ
        if( i0 < 0 )
            return -1;
        return block[0] & 0xFF;
    }

    /**
     * ubNǂݏo
     * @param buf ǂݏo
     * @param offset buf̊Jnʒu
     * @param length ǂݏo
     * @return ۂɓǂݏo EOFB-1
     */
    public int read( byte[] buf, int offset, int length ) throws IOException {
        if( length <= 0 )
            return 0;

        int begin = offset;
        int val;
        while( true ) {
            if( sp == 0 ) {
                if( pos == len && loadBlock() <= 0 ) {
                    if( length > 0 && offset == begin )
                        return -1;
                    break;
                }
                val = block[pos++] & 0xFF;
            } else {
                val = stack[--sp];
            }

            int code = dict[val];
            if( code == val ) {
                buf[offset++] = (byte)val;
                if( --length == 0 )
                    break;
            } else {
                stack[sp++] = code >> 8;
                stack[sp++] = code & 0xFF;
            }
        }

        return offset - begin;
    }

    /**
     * obt@BPEf[^ubNǂݍ݁AWJ
     * @return ubNTCY EOFB-1
     */
    protected int loadBlock() throws IOException {
        int i0, i1, i2;

        // ubNTCY擾
        if( in == null )
            return -1;

        i0 = in.read();
        if( i0 < 0 ) {
            in = null;
            return -1;
        }
        i1 = in.read();
        if( i1 < 0 )
            throw new IOException( "unexpected EOF" );
        len = i0 | (i1 << 8);

        if( len > block.length )
            block = new byte[len]; // obt@TCYg

        // f[^ubNǂݍ
        for( i0 = 0; i0 < len; ) {
            i0 = in.read( block, i0, len - i0 );
            if( i0 < 0 )
                throw new IOException( "unexpected EOF" );
        }
        pos = 0;

        // WJ
        for( i0 = 0; i0 < 256; ) {
            i1 = block[pos++];
            if( i1 < 0 ) {
                i1 = i0 + i1 + 128;
                while( i0 <= i1 ) {
                    dict[i0] = i0;
                    i0++;
                }
                if( i0 == 256 )
                    break;
                i1 = 0;
            }
            i1 += i0;
            while( i0 <= i1 ) {
                i2 = block[pos++] & 0xFF;
                if( i2 != i0 )
                    i2 |= (block[pos++] & 0xFF) << 8;
                dict[i0] = i2;
                i0++;
            }
        }

        sp = 0;
        return len;
    }

    /**
     * Xg[
     */
    public void close() throws IOException {
        if( in != null ) {
            in.close();
            in = null;
        }
    }
}
