/*
 * Copyright (c) 2003, Influenza. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
import com.nttdocomo.io.*;
import javax.microedition.io.*;
import java.io.*;
import java.util.*;

/**
 * data.bpẽtH[}bg
 *  +0 FORMAT_VERSION(=0x01)
 *  +1 DATE_VERSION f[^쐬 short^little-endian
 *      (yyyy - 1900) * 12 * 32 + (mm - 1) * 32 + dd
 *  +3 ACef[^ short^little-endian
 *  +5 Vsf[^ short^little-endian
 *  +7` BPEkς݃ACe&Vsf[^
 *       ef[^̃tH[}bgItemNXARecipeNXQ
 *
 * XNb`pbh̃f[^\
 *  +0 }WbNio[(int) N`FbNɗp
 *  +4 f[^`̃o[W($FORMAT_VERSION)
 *  +5+6 f[^XV (N - 1900) * 384 + ( - 1) * 32 + 
 *  +7+8 ACe
 *  +9+10 Vs
 *  +11 ɓǂݍރf[^ʒu(10KBP) 255Ȃǂݍ݊
 *  +12 tO b7:ŝ߃ACeڍ׏WJȂ
 *  +13` gp
 *
 *  +32` ACef[^
 *  +??` Vsf[^
 */
public class IO {
    /**
     * wb_̊etB[hItZbg
     */
    private static final int OFFSET_MAGIC_NUMBER   = 0;
    private static final int OFFSET_FORMAT_VERSION = 4;
    private static final int OFFSET_DATA_VERSION   = 5;
    private static final int OFFSET_NUM_OF_ITEM    = 7;
    private static final int OFFSET_NUM_OF_RECIPE  = 9;
    private static final int OFFSET_LOAD_PROGRESS  = 11;
    private static final int OFFSET_FLAGS          = 12;
    private static final int FLAG_LOW_MEMORY       = 0x80;

    /**
     * o[W̃AvΉĂFORMAT_VERSION
     */
    private static final int SUPPORTED_VERSION = 0x01;

    /**
     * CGĨx[XURL
     */
    static String baseURL;

    /**
     * XNb`pbh̃wb_LbV
     */
    static byte[] header;

    /**
     * 
     * @param sourceURL x[XURL
     * @param models ߂li[pz [0]=Item [1]=Recipe
     * @return f[^XV (yyyy * 10000) + (mm * 10) + dd
     */
    public static int init( String sourceURL, Model[] models ) throws Exception {
        int i0;
        final int MAGIC_NUMBER = 20031028;

        baseURL = sourceURL;
        header = new byte[32];

        // XNb`pbh̃wb_ǂݏo
        loadHeader();

        // N`FbN
        if( readInt( header, OFFSET_MAGIC_NUMBER ) != MAGIC_NUMBER ) {
            // NȂ̂Ńwb_
            for( i0 = 0; i0 < header.length; i0++ )
                header[i0] = 0;
            writeInt( header, OFFSET_MAGIC_NUMBER, MAGIC_NUMBER );
            storeHeader();
            System.out.println( "scratchpad initialized." );
        }

        // ACeƃVsf[^̍\z
        Item item = null;
        Recipe recipe = null;
        while( (header[OFFSET_LOAD_PROGRESS] & 0xFF) == 255 ) {
            InputStream in = new BPEInputStream(
                      Connector.openInputStream( "scratchpad:///0;pos=32" ) );

            boolean detail = ((header[OFFSET_FLAGS] & FLAG_LOW_MEMORY) == 0);
            i0 = readShort( header, OFFSET_NUM_OF_ITEM );
            long start = System.currentTimeMillis();
            item = new Item( in, i0, detail );
            long end = System.currentTimeMillis();
            System.out.println( "Item: " + (end - start) + "msec." );

            i0 = readShort( header, OFFSET_NUM_OF_RECIPE );
            try {
                start = System.currentTimeMillis();
                recipe = new Recipe( in, i0 );
                end = System.currentTimeMillis();
                System.out.println( "Recipe: " + (end - start) + "msec." );
            } catch( OutOfMemoryError e ) {
                System.out.println( "caught OutOfMemoryError!" );
                item = null;
                if( detail ) {
                    in.close();
                    System.gc();
                    header[OFFSET_FLAGS] |= FLAG_LOW_MEMORY;
                    storeHeader();
                    continue; // ACe̐WJȂōĒ
                }
            }
            in.close();
            break;
        }
        if( item == null )
            item = new Item( null, 0, false );
        if( recipe == null )
            recipe = new Recipe( null, 0 );

/*
        InputStream in = Connector.openInputStream( "resource:///data.bpe" );
        int formatVersion = in.read();
        int dataVersion = in.read();
        dataVersion |= in.read() << 8;
        int itemNum = in.read();
        itemNum |= in.read() << 8;
        int recipeNum = in.read();
        recipeNum |= in.read() << 8;
        in = new BPEInputStream( in );
        item = new Item( in, itemNum, true );
        recipe = new Recipe( in, recipeNum );
        in.close();
*/

        models[0] = item;
        models[1] = recipe;

        i0 = readShort( header, OFFSET_DATA_VERSION );
        return i0 % 32
             + (((i0 / 32) % 12) + 1) * 100
             + ((i0 / 32 / 12) + 1900) * 10000;
    }

    /**
     * T[õf[^XVĂ邩ǂׂ
     * @return ^O 0ȂXVĂȂ
     */
    public static int query() throws Exception {
        // ŐVf[^̃^OFORMAT_VERSIONADATA_VERSION擾
        String url = baseURL + "bin/loader.cgi?query=data.bpe&len=3";
        byte[] buf = new byte[7];
        int len = get( url, buf, 0, 7 );
        if( len != 7 )
            throw new RuntimeException( "query len=" + len );

        int tag           = readInt( buf, 0 );
        int formatVersion = buf[4] & 0xFF;
        int dataVersion   = readShort( buf, 5 );

        if( formatVersion != SUPPORTED_VERSION ) {
            throw new RuntimeException(
                       "AvŐVɂĂ:ver=" + formatVersion );
        }

        if( dataVersion != readShort( header, OFFSET_DATA_VERSION ) ) {
            // f[^XVĂ(ÂȂĂĂXVƂ݂Ȃ)
            return tag;
        }

        if( (header[OFFSET_LOAD_PROGRESS] & 0xFF) < 255 ) {
            // f[^͍XVĂȂǂݍ݂ĂȂ
            return tag;
        }

        // _E[h̕KvȂ
        return 0;
    }

    /**
     * T[of[^_E[hăXNb`pbhɕۑ
     * View\
     * @param tag ^O
     */
    public static void download( int tag ) throws Exception {
        try {
            byte[] buf = new byte[10240];

            // ^f[^擾
            String url = baseURL + "bin/loader.cgi?len=7&file=data.bpe." + tag;
            int len = get( url, buf, 0, 7 );
            if( len != 7 )
                throw new RuntimeException( "header len=" + len );

            int formatVersion = buf[0] & 0xFF;
            int dataVersion   = readShort( buf, 1 );
            int itemNum       = readShort( buf, 3 );
            int recipeNum     = readShort( buf, 5 );

            if( dataVersion != readShort( header, OFFSET_DATA_VERSION ) ) {
                header[OFFSET_LOAD_PROGRESS] = 0;
                writeShort( header, OFFSET_DATA_VERSION, dataVersion );
                writeShort( header, OFFSET_NUM_OF_ITEM, itemNum );
                writeShort( header, OFFSET_NUM_OF_RECIPE, recipeNum );
            }

            for( int i = 0; i < 10; i++ ) {
                View.obj.progress( "[h...", i * 10 );
                if( i < (header[OFFSET_LOAD_PROGRESS] & 0xFF) )
                    continue; // łɃ[hς݂ȂXLbv
                header[OFFSET_LOAD_PROGRESS] = (byte)i;

                url = baseURL + "bin/loader.cgi?file=data.bpe." + tag
                                     + "&len=10240&pos=" + (i * 10240 + 7);
                len = get( url, buf, 0, 10240 );
                store( buf, len, i * 10240 + 32 );

                if( len != 10240 )
                    break;
            }
            // ǂݍ݊!
            header[OFFSET_LOAD_PROGRESS] = (byte)255;

        } finally {
            storeHeader();
        }
    }

    /**
     * HTTPGET\bhŃRec擾
     * @param url NGXgURL
     * @param buf ǂݍ݃obt@
     * @param offset buf̓ǂݍ݊Jnʒu
     * @param length ǂݍޒ
     * @return ǂݍ񂾒
     */
    private static int get( String url, byte[] buf, int offset, int length ) throws Exception {
        System.out.println( url );
        HttpConnection conn;
        conn = (HttpConnection)Connector.open( url, Connector.READ, true );
        conn.setRequestMethod( HttpConnection.GET );
        conn.connect();
        int len = (int)conn.getLength();
        if( length < len )
            len = length;

        InputStream in = conn.openInputStream();
        for( int i = 0; i < len; ) {
            int j = in.read( buf, offset + i, len - offset - i );
            i += j;
        }
        in.close();
        conn.close();

        return len;
    }

    /**
     * XNb`pbhwb_ǂݏo
     */
    private static void loadHeader() throws Exception {
        InputStream in = Connector.openInputStream( "scratchpad:///0" );
        try {
            in.read( header );
        } finally {
            in.close();
        }
    }

    /**
     * XNb`pbhɃwb_
     */
    private static void storeHeader() throws Exception {
        OutputStream out = Connector.openOutputStream( "scratchpad:///0" );
        try {
            out.write( header, 0, header.length );
        } finally {
            out.close();
        }
    }

    private static void store( byte[] buf, int len, int pos ) throws Exception {
        OutputStream out = Connector.openOutputStream( "scratchpad:///0;pos=" + pos );
        try {
            out.write( buf, 0, len );
        } finally {
            out.close();
        }
    }

    /**
     * str.txtStringzɓǂݍ
     */
    public static String[] loadWords() throws Exception {
        InputStream in = Connector.openInputStream( "resource:///str.txt" );
        final int BUF_SIZE = 200;
        byte[] buf = new byte[BUF_SIZE];

        Vector v = new Vector();
        int i = 0;
        while( true ) {
            int len = in.read( buf, i, BUF_SIZE - i );
            if( len < 0 )
                break; // bufɎcŌ̗vf͎̂Ă̂','ŏI!
            len += i;
            int j = 0;
            while( i < len ) {
                if( buf[i++] == ',' ) {
                    v.addElement( new String( buf, j, i - j - 1 ).trim() );
                    j = i;
                }
            }
            i = 0;
            while( j < len )
                buf[i++] = buf[j++];
        }
        in.close();

        String[] words = new String[v.size()];
        v.copyInto( words );

        return words;
    }

    /**
     * zoffsetʒu32bit(little-endian)ǂݎ
     */
    public static int readInt( byte[] array, int offset ) {
        return (array[offset] & 0xFF)
             | ((array[offset + 1] & 0xFF) << 8)
             | ((array[offset + 2] & 0xFF) << 16)
             | ((array[offset + 3] & 0xFF) << 24);
    }

    /**
     * zoffsetʒu32bit(little-endian)
     */
    public static void writeInt( byte[] array, int offset, int value ) {
        array[offset]     = (byte)value;
        array[offset + 1] = (byte)(value >> 8);
        array[offset + 2] = (byte)(value >> 16);
        array[offset + 3] = (byte)(value >> 24);
    }

    /**
     * zoffsetʒu16bit(little-endian)ǂݎ
     */
    public static int readShort( byte[] array, int offset ) {
        return (array[offset] & 0xFF) | ((array[offset + 1] & 0xFF) << 8);
    }

    /**
     * zoffsetʒu16bit(little-endian)
     */
    public static void writeShort( byte[] array, int offset, int value ) {
        array[offset]     = (byte)value;
        array[offset + 1] = (byte)(value >> 8);
    }
}
