/*
 * Copyright (c) 2003, Influenza. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
import java.io.*;

/**
 * ACef[^
 */
public class Item implements Model {

    private static final int WAR = 1 << 15;
    private static final int MNK = 1 << 14;
    private static final int RDM = 1 << 13;
    private static final int BLM = 1 << 12;
    private static final int WHM = 1 << 11;
    private static final int THF = 1 << 10;
    private static final int PLD = 1 << 9;
    private static final int DRK = 1 << 8;
    private static final int RNG = 1 << 7;
    private static final int BRD = 1 << 6;
    private static final int BST = 1 << 5;
    private static final int SAM = 1 << 4;
    private static final int DRG = 1 << 3;
    private static final int NIN = 1 << 2;
    private static final int SMN = 1 << 1;

    private static final int UNKNOWN   = 0;
    private static final int OTHER     = 1;
    private static final int FIGHT     = 2;
    private static final int DAGGER    = 3;
    private static final int SWORD     = 4;
    private static final int TH_SWORD  = 5;
    private static final int AXE       = 6;
    private static final int TH_AXE    = 7;
    private static final int TH_SCYTHE = 8;
    private static final int SPEAR     = 9;
    private static final int KATANA    = 10;
    private static final int TH_KATANA = 11;
    private static final int MACE      = 12;
    private static final int STAFF     = 13;
    private static final int HARP      = 14;
    private static final int FLUTE     = 15;
    private static final int BOW       = 16;
    private static final int GUN       = 17;
    private static final int THROW     = 18;
    private static final int FISHING   = 19;
    private static final int SHIELD    = 20;
    private static final int HELM      = 21;
    private static final int NECK      = 22;
    private static final int ARMOR     = 23;
    private static final int HANDS     = 24;
    private static final int BELT      = 25;
    private static final int LEGS      = 26;
    private static final int SHOES     = 27;
    private static final int CLOAK     = 28;
    private static final int EARRING   = 29;
    private static final int RING      = 30;

    private static String[] names;
    private int[] attributes;
    public int maxLevel;

    /**
     * Xg[ACeǂݏoĔzɊi[
     *
     * ̓Xg[`
     *   [ACe̒(byte)][A][C][e][][]c
     * +0[ Hum | Hum | Elv | Elv | Tar | Tar |  Mit  |  Gar  ]
     * +1[  RNG  |  BRD  |  BST  |  SAM  |  DRG  |  NIN  |  SMN  |  ---  ]
     * +2[  WAR  |  MNK  |  RDM  |  BLM  |  WHM  |  THF  |  PLD  |  DRK  ]
     * +3[  Ex   | Rare  | Stack |                JeS               ]
     * +4[                        \x                         ]
     * +5[̒(byte)][][][]c
     *
     * f[^`
     *   names[index * 2]     = ACe
     *   names[index * 2 + 1] = 
     *   attributes[index * 2] =
     *   [ Hum | Hum | Elv | Elv | Tar | Tar |  Mit  |  Gar  |
     *   |  WAR  |  MNK  |  RDM  |  BLM  |  WHM  |  THF  |  PLD  |  DRK  |
     *   |  RNG  |  BRD  |  BST  |  SAM  |  DRG  |  NIN  |  SMN  |  ---  |
     *   |  Ex   | Rare  | Stack |                JeS               ]
     *   attributes[index * 2 + 1] =
     *   [  b31  |  b30  |  b29  |  b28  |  b27  |  b26  |  b25  |  b24  |
     *   |  b23  |  b22  |  b21  |  b20  |  b19  |  b18  |  b17  |  b16  |
     *   |  b15  |  b14  |  b13  |  b12  |  b11  |  b10  |  b9   |  b8   |
     *   |                        \x                         ]
     * @param in ̓Xg[
     * @param num ACe
     * @param detail truêƂWJ
     */
    public Item( InputStream in, int num, boolean detail ) throws IOException {
        names = new String[num * 2];
        attributes = new int[num * 2];

        byte[] buf = new byte[200]; // ̓eLg[
        maxLevel = 1;
        for( int i = 0; num > 0; num-- ) {
            if( (i & 0x7F) == 0 )
                View.obj.progress( "ACeWJ...", 100 * i / names.length );

            // ACe
            int len = in.read( buf, 0, in.read() );
            names[i] = new String( buf, 0, len );

            // e푮
            in.read( buf, 0, 6 );
            attributes[i] = ((buf[0] & 0xFF) << 24)
                          | ((buf[2] & 0xFF) << 16)
                          | ((buf[1] & 0xFF) << 8)
                          | (buf[3] & 0xFF);
            i++;
            attributes[i] = buf[4] & 0xFF;
            if( attributes[i] > maxLevel )
                maxLevel = attributes[i];

            // B0Ȃ]vȃCX^X͍Ȃ
            if( buf[5] > 0 ) {
                len = in.read( buf, 0, buf[5] );
                if( detail )
                    names[i] = new String( buf, 0, len );
            }
            i++;
        }
    }

    /**
     * ACe
     * @param result
     * @param name ACe(v) or null
     * @param category JeS or 0
     * @param job Wu or 0
     * @param minLevel Kvx or 0
     * @param maxLevel Kvx or 0
     * @return v
     */
    public int search( short[] result, String name, int category,
                            int job, int minLevel, int maxLevel ) {
        int total = names.length / 2;
        int max = result.length;
        int jobMask = 1 << (24 - job);

        int rows = 0;
        for( int i = 0; i < total; i++ ) {

            // ACe̕v
            if( name != null && names[i * 2].indexOf( name ) < 0 )
                continue;

            // JeS̈v
            if( category > 0 && (attributes[i * 2] & 0x1F) != category )
                continue;

            // Wüv
            if( job > 0 && (attributes[i * 2] & jobMask) == 0 )
                continue;

            // \x
            int requireLevel = attributes[i * 2 + 1] & 0xFF;
            if( minLevel > 0 && requireLevel < minLevel )
                continue;
            if( maxLevel > 0 && requireLevel > maxLevel )
                continue;

            result[rows++] = (short)(i + 1);
            if( rows >= max )
                break;
        }
        return rows;
    }

    /**
     * Xg\p̃ACe𐮌`ĕԂ
     */
    public String formatName( int id ) {
        return getName( id );
    }

    /**
     * Xg\p̃ACe𐮌`ĕԂ
     */
    public String formatInfo( int id ) {
        int i0, i1;
        i0 = (id - 1) * 2;
        i1 = attributes[i0];

        StringBuffer sb = new StringBuffer();
        //sb.append( id );
        int category = i1 & 0x1F;
        int level = attributes[i0 + 1] & 0xFF;
        if( level > 0 ) {
            sb.append( 'L' );
            sb.append( level );
            sb.append( ' ' );
        }
        String s = names[i0 + 1];
        if( s != null )
            sb.append( s );

        return sb.toString();
    }

    /**
     * ACeڍ׏𐮌`ĕԂ
     */
    public String formatDetail( int id ) {
        int i0, i1;
        i0 = (id - 1) * 2;
        i1 = attributes[i0];

        StringBuffer sb = new StringBuffer();

        // O
        sb.append( getName( id ) );
        sb.append( '\n' );

        // ACe
        sb.append( '(' );
        sb.append( iMoogle.getCategory( i1 & 0x1F ) );
        sb.append( ')' );
        sb.append( ' ' );

        // \x
        int level = attributes[i0 + 1] & 0xFF;
        if( level > 0 ) {
            sb.append( 'L' );
            sb.append( level );
            sb.append( ' ' );
        }

        // \푰
        if( (i1 & 0xFF000000) == 0xFF000000 ) {
            sb.append( iMoogle.getRace( 0 ) );
        } else {
            for( int i = 1; i <= 8; i++ ) {
                if( (i1 & (1 << (32 - i))) != 0 )
                    sb.append( iMoogle.getRace( i ) );
            }
        }
        sb.append( '\n' );

        // \Wu
        for( int i = 1; i <= 15; i++ ) {
            if( (i1 & (1 << (24 - i))) != 0 )
                sb.append( iMoogle.getJob( i ) );
        }
        sb.append( '\n' );

        // 
        String s = names[i0 + 1];
        if( s != null )
            sb.append( s );

        return sb.toString();
    }

    /**
     * ACeԂ
     * @param id ACeID(1`)
     */
    public static String getName( int id ) {
        if( id == 0 || id > names.length / 2 - 1 ) {
            System.out.println( "Item#getName error:" + id );
        }
        return names[id * 2 - 2];
    }

    /**
     * f[^Ԃ
     */
    public int getCount() {
        return names.length / 2;
    }

    /**
     * SACe̍ő呕\xԂ
     * tH[ɂ͎xpB
     */
    public int getMaxLevel() {
        return maxLevel;
    }
}
