/*
 * Copyright (c) 2003, Influenza. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
import java.io.*;

/**
 * VsModel
 */
class Recipe implements Model {
    private byte[] recipes;

    private static final int SIZE = 45;
    public int maxLevel;

    /**
     * Xg[烌VsǂݏoĔzɊi[
     *
     * ̓Xg[`
     *   [   |   |  ---  |  ---  |  ---  |    gpNX^     ]
     *   [     KvXL      | i̎  |       fނ̐        ]
     *
     *   ԖڂCKvXL
     *   [     KvXL    |XLAbv(KvXL̑) ]
     *   [                        KvXLx                       ]
     *   [     KvXL    |XLAbv(KvXL̑) ]
     *   [                        KvXLx                       ]
     *
     *   [                             f1                             |
     *   |                                                               ]
     *   [                             f2                             |
     *   |                                                               ]
     *   [                             f3                             |
     *   |                                                               ]
     *   [                             f4                             |
     *   |                                                               ]
     *   [                             f5                             |
     *   |                                                               ]
     *   [                             f6                             |
     *   |                                                               ]
     *   [                             f7                             |
     *   |                                                               ]
     *   [                             f8                             |
     *   |                                                               ]
     *
     *   [                            i(NQ)                         |
     *   |                                                               ]
     *   [                            i(NQ)̐                     ]
     *   [                            i(HQ1)                        |
     *   |                                                               ]
     *   [                            i(HQ1)̐                    ]
     *   [                            i(HQ2)                        |
     *   |                                                               ]
     *   [                            i(HQ2)̐                    ]
     *   [                            i(HQ3)                        |
     *   |                                                               ]
     *   [                            i(HQ3)̐                    ]
     *
     *                             tO Kv      
     * CXLKv/m     off     Kvl    l-Kvl
     * CXLKvls      on      N*10 l-N*10
     * CXLls      off     Kvl    31
     * CXLKv/s     on      N*10 31
     * BVsKv/m       off     Kvl    l-Kvl
     * BVsKvls        on      l-10 10
     * BVsls        off     Kvl    31
     * BVsKv/s       on      0         31
     * TuXLKv/m       -       Kvl    l-Kvl
     * TuXLKvls        -       l    30
     * TuXLs          -       Kvl    31
     * TuXLKv/s       -       255       31
     *
     * f[^`
     *  +0 [   |   |    gpNX^     |    CXL       ]
     *   CXL 0:b 1:ٖD 2:B 3:؍H 4: 5:v 6: 7:
     *   NX^   0:   1:   2:y   3:   4:   5:X 6: 7:
     *  +1 KvbXLx(255=s)
     *  +2 bXLAbv(255=s)
     *   :
     *  +15 KvXL(255=s)
     *  +16 XLAbv(255=s)
     *  +17+18 f1
     *   :
     *  +31+32 f8
     *  +33+34 ʏ튮i
     *  +35    ʏ튮ǐ
     *  +36+37 HQ1
     *  +38    HQ1̌
     *  +39+40 HQ2
     *  +41    HQ2̌
     *  +42+43 HQ3
     *  +44    HQ3̌
     *
     * @param in ̓Xg[
     * @param num Vs
     */
    public Recipe( InputStream in, int num ) throws IOException {
        recipes = new byte[SIZE * num];

        byte[] buf = new byte[200]; // ̓eLg[
        for( int i = 0; i < num; i++ ) {
            if( i % 100 == 0 )
                View.obj.progress( "VsWJ...", 100 * i / num );

            int p = SIZE * i;
            in.read( buf, 0, 4 );

            int materialsNum = (buf[1] & 0x07) + 1;
            int goodsNum     = ((buf[1] & 0x18) >> 3) + 1;
            int skillNum     = ((buf[1] & 0xE0) >> 5) + 1;

            int skill = (buf[2] & 0xE0) >> 5;
            int max   = buf[2] & 0x1F;
            int min   = buf[3] & 0xFF;
            if( max == 31 )
                max = min - 1;
            max += min;
            if( buf[0] >= 0 && min == 0 )
                min = -1;
            recipes[p] = (byte)(skill                   // CXL
                              | ((buf[0] & 0x07) << 3)  // gpNX^
                              | (buf[0] & 0xC0));       // tO
            recipes[p + 1 + skill * 2] = (byte)min;
            recipes[p + 2 + skill * 2] = (byte)max;
            if( max >= 0 && max > maxLevel )
                maxLevel = max;

            // TuXLǂݏo
            for( ; skillNum > 1; skillNum-- ) {
                in.read( buf, 0, 2 );
                skill = (buf[0] & 0xE0) >> 5;
                max   = buf[0] & 0x1F;
                min   = buf[1] & 0xFF;
                if( max < 30 ) {
                    max += min;
                } else if( max == 30 ) {
                    max = min;
                    min = -1;
                } else {
                    max = -1;
                }
                recipes[p + 1 + skill * 2] = (byte)min;
                recipes[p + 2 + skill * 2] = (byte)max;
            }

            // fރXgǂݏo
            int j = p + 17;
            for( ; materialsNum > 0; materialsNum-- ) {
                in.read( buf, 0, 2 );
                recipes[j++] = buf[0];
                recipes[j++] = buf[1];
            }

            // iXgǂݏo
            j = p + 33;
            for( ; goodsNum > 0; goodsNum-- ) {
                in.read( buf, 0, 3 );
                recipes[j++] = buf[0];
                recipes[j++] = buf[1];
                recipes[j++] = buf[2];
            }

/*
System.out.println( "Guild: " + recipes[i * SIZE] );
System.out.println( "Crytal: " + recipes[i * SIZE + 1] );
System.out.println( "Dissolve: " + recipes[i * SIZE + 2] );
System.out.println( "skillFlags: " + skillFlags );
for( int j = 0; j < 9; j++ )
    System.out.println( "bٖDB؍Hv  ނ蒲".substring( j * 2, j * 2 + 2) + ": " + recipes[i * SIZE + 3 + j * 2] + "/" + recipes[i * SIZE + 4 + j * 2] );
for( int j = 0; j < 8; j++ ) {
    int xitemID = (recipes[i * SIZE + 21 + j * 2] & 0xFF) + ((recipes[i * SIZE + 22 + j * 2] & 0xFF) << 8);
    System.out.println( "f" + (j + 1) + ": " + Item.getName(xitemID)+"(" + xitemID + ")" );
}
for( int j = 0; j < 4; j++ ) {
    int xitemID = ((recipes[i * SIZE + 37 + j * 3] & 0xFF) + ((recipes[i * SIZE + 38 + j * 3] & 0xFF) << 8));
    System.out.println( "NQ HQ1HQ2HQ3".substring( j * 3, j * 3 + 3 ) + ": " + Item.getName(xitemID)+ "(" +  xitemID + ")" );
}
break;
*/
        }
    }

    /**
     * Vs
     * @param result
     * @param item iID or ChJ[h0
     * @param guild Mh or ChJ[h0
     * @param crystal gpNX^ or ChJ[h0
     * @param require CKvXLx or ChJ[h0
     * @param limit CEXLx or ChJ[h0
     * @return v
     */
    public int search( short[] result, int item, int guild,
                              int crystal, int require, int limit ) {
System.out.println( " item: " + item
                  + " guild: " + guild
                  + " crystal: " + crystal
                  + " require: " + require
                  + " limit: " + limit );
        int max = result.length;
        guild--;
        crystal--;

        int rows = 0;
        main: for( int i = 0; i < recipes.length; i += SIZE ) {
            // i܂͑fނ̈v
            if( item > 0 ) {
                sub: while( true ) {
                    int k = i + 17;
                    for( int j = 0; j < 8; j++ ) {
                        int material = (recipes[k] & 0xFF)
                                     | ((recipes[k + 1] & 0xFF) << 8);
                        if( material == item )
                            break sub;
                        k += 2;
                    }
                    for( int j = 0; j < 4; j++ ) {
                        int itemID = (recipes[k] & 0xFF)
                                   | ((recipes[k + 1] & 0xFF) << 8);
                        if( itemID == item )
                            break sub;
                        k += 3;
                    }
                    continue main;
                }
            }

            // CXL̈v
            int g = recipes[i] & 0x07;
            if( guild >= 0 && g != guild )
                continue;

            // gpNX^̈v
            if( crystal >= 0 && ((recipes[i] & 0x38) >> 3) != crystal )
                continue;

            // KvXLx
            if( require > 0 ) {
                int lv = recipes[i + 1 + g * 2] & 0xFF;
                if( lv != 255 && require < lv )
                    continue; // requirẽxł͍Ȃ
            }
            // EXLx
            if( limit > 0 ) {
                int lv = recipes[i + 2 + g * 2] & 0xFF;
                if( lv != 255 && lv <= limit )
                    continue; // limit̃xł͂XL͏㏸Ȃ
            }

            result[rows++] = (short)(i / SIZE);
/*
int i0 = (recipes[i + 37] & 0xFF)
       + ((recipes[i + 38] & 0xFF) << 8);
for( int j = 0; j < 9; j++ ) System.out.print( (recipes[i + 3 + j * 2] & 0xFF) + "," );
System.out.println( itemNames[i0 * 2] + "(" + i0 + ")" );
*/
            if( rows >= max )
                break;
        }
        return rows;
    }

    public String formatName( int id ) {
        int i0 = SIZE * id;
        int nq = (recipes[i0 + 33] & 0xFF)
               | ((recipes[i0 + 34] & 0xFF) << 8);
        return Item.getName( nq );
    }

    public String formatInfo( int id ) {
        StringBuffer sb = new StringBuffer();
        int i0 = SIZE * id;
        boolean guess = (recipes[i0] < 0);
        int guild = recipes[i0] & 0x07;
        int crystal = (recipes[i0] & 0x38) >> 3;
        int mainSkillMin = recipes[i0 + 1 + guild * 2] & 0xFF;
        int mainSkillMax = recipes[i0 + 2 + guild * 2] & 0xFF;
        //sb.append( id );
        sb.append( iMoogle.getCrystal( crystal + 1 ) );
        sb.append( ' ' );
        sb.append( iMoogle.getGuild( guild + 1 ) );
        if( mainSkillMin == 255 || guess ) {
            sb.append( '?' );
        } else {
            sb.append( mainSkillMin );
        }
        sb.append( '-' );
        if( mainSkillMax == 255 ) {
            sb.append( '?' );
        } else {
            sb.append( mainSkillMax );
        }
        return sb.toString();
    }

    public String formatDetail( int id ) {
        int i0 = SIZE * id;
        StringBuffer sb = new StringBuffer();
        for( int i = 0; i < 4; i++ ) {
            int i1 = i0 + 33 + i * 3;
            int item = (recipes[i1] & 0xFF) | ((recipes[i1 + 1] & 0xFF) << 8);
            if (item == 0)
                continue;
            int num = (recipes[i1 + 2] & 0xFF);
            sb.append( Item.getName( item ) );
            sb.append( ' ' );
            sb.append( 'x' );
            sb.append( num );
            sb.append( '\n' );
        }
        for( int i = 0; i < 8; i++ ) {
            int i1 = i0 + 17 + i * 2;
            int item = (recipes[i1] & 0xFF) | ((recipes[i1 + 1] & 0xFF) << 8);
            if (item == 0)
                continue;
            sb.append( ' ' );
            sb.append( Item.getName( item ) );
            sb.append( '\n' );
        }
        return sb.toString();
    }

    /**
     * f[^Ԃ
     */
    public int getCount() {
        return recipes.length / SIZE;
    }
}
