/*
 * Copyright (c) 2003, Influenza. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
import com.nttdocomo.ui.*;

class View extends Canvas {
    /* AstaticɂǂłQƂĂc */
    static View obj;

    /* Oǐ՗p */
    public static int trace;

    private Graphics g;
    private int w;
    private int h;
    Font f;

    public void paint( Graphics g ) {
    }

    public View() {
        trace = 10;
        g = getGraphics();
        w = getWidth();
        h = getHeight();
        trace = 11;
        f = Font.getFont( Font.FACE_SYSTEM|Font.SIZE_MEDIUM|Font.STYLE_PLAIN );
        /* Œ12s\łȂƂSIZE_SMALLɂB
           łF504V[Y11.25s\łȂ */
        if( h < f.getHeight() * 12 )
            f = Font.getFont( Font.FACE_SYSTEM|Font.SIZE_SMALL|Font.STYLE_PLAIN );
        obj = this;
        trace = 19;
    }

    /**
     * ҂ʕ\
     * @param message ҂bZ[W
     * @param width i(%)
     */
    public void progress( String message, int width ) {
        g.lock();
        clearRow( g, 0, h, false );
        g.setColor( g.getColorOfName( g.WHITE ) );
        g.drawString( message, (w - f.stringWidth( message )) / 2, h / 2 - f.getHeight() );

        // vOXo[`
        int x = (w - 20) * width / 100;
        int y = h / 2 + 2;
        g.drawRect( 9, y, w - 20, 10 );
        g.setColor( g.getColorOfRGB( 210, 255, 255 ) );
        g.fillRect( 10, y + 1, x, 9 );

        g.unlock( true );
    }

    /**
     * ėpXg\
     * @param header ʂ̖O
     * @param result ACeID܂̓VsID̃Xg
     * @param len result̗L
     * @param cur J[\ʒu
     * @param m \`IuWFNg
     * @return 0ȏ : J[\ʒu
     *         0 : nhȂL[R[h - 32
     * @see Model#formatName( int id )
     * @see Model#formatInfo( int id )
     */
    public int list( String header, short[] result, int len, int cur, Model m ) {
        trace = 40;
        int i0;
        int ascent = f.getAscent();
        int fh     = f.getHeight();
        int top = fh;
        int bottom = h - fh * 2;
        int pageSize = (bottom - top) / fh;
        int pageHeight = pageSize * fh;
        StringBuffer sb = new StringBuffer();

        final int REPEAT_BEGIN = 300; // L[s[gJn(~b)
        final int REPEAT_PITCH = 80;  // L[s[gԊu(~b)

        g.lock();
        clearRow( g, 0, h, false );
        g.setColor( g.getColorOfName( g.WHITE ) );
        if( len < result.length )
            g.drawString( header, 0, ascent );
        else
            g.drawString( header + " " + result.length + "", 0, ascent );

        if( len == 0 ) {
            g.drawString( "YȂ", 0, fh + ascent );
            g.unlock( true );
            relWait( 0 );
            trace = 49;
            return keyWait() - 32;
        }

        int waitTime = 0;
        int offset = cur - pageSize / 2;
        while( true ) {
            trace = 41;
            if( cur >= len )
                cur = len - 1;
            if( cur < 0 )
                cur = 0;
            if( offset + pageSize <= cur )
                offset = cur - pageSize + 1;
            if( offset > cur )
                offset = cur;
            if( offset + pageSize >= len )
                offset = len - pageSize;
            if( offset < 0 )
                offset = 0;

            g.lock();
            for( int i = 0; i < pageSize; i++ ) {
                int num = offset + i;
                int y = top + i * fh;
                clearRow( g, y, fh, (num == cur) );
                if( num >= len )
                    continue;
                g.setColor( g.getColorOfName( g.WHITE ) );
                g.drawString( m.formatName( result[num] ), 4, y + ascent );
            }

            // I𒆗vf̏ڍו\
            trace = 42;
            clearRow( g, bottom, h - bottom, false );
            printLines( m.formatInfo( result[cur] ), 0, bottom, w, h - bottom );

            // XN[o[\
            trace = 43;
            g.setColor( g.getColorOfRGB( 210, 210, 210 ) );
            g.fillRect( w - 4, top, 4, pageHeight );
            if( len > pageSize ) {
                g.setColor( g.getColorOfRGB( 250, 170, 210 ) );
                g.fillRect( w - 4, top + offset * pageHeight / len,
                                4, pageSize * pageHeight / len );
            }
            g.unlock( true );

            trace = 44;
            if( relWait( waitTime ) ) {
                waitTime = 0;
            }
            int k = keyWait();
            waitTime = (waitTime == 0) ? REPEAT_BEGIN : REPEAT_PITCH;
            switch( k ) {
            case Display.KEY_UP:
                cur--;
                break;
            case Display.KEY_DOWN:
                cur++;
                break;
            case Display.KEY_LEFT:
                cur -= pageSize;
                offset -= pageSize;
                break;
            case Display.KEY_RIGHT:
                cur += pageSize;
                offset += pageSize;
                break;
            case Display.KEY_SELECT:
                trace = 49;
                return cur;
            default:
                trace = 49;
                return k - 32;
            }
        }
    }

    /**
     * ڍ׉
     * @return L[R[h
     */
    public int detail( int id, Model m ) {
        trace = 50;
        g.lock();
        clearRow( g, 0, h, false );
        trace = 51;
        printLines( m.formatDetail( id ), 0, 0, w, h );
        g.unlock( true );

        relWait( 0 );
        trace = 59;
        return keyWait();
    }

    /**
     * ܂ԂȂ\
     * F504V[YȊO12s\\Ȃ͂B
     * @param s 
     * @param x \̈x
     * @param y \̈y
     * @param w \̈敝
     * @param h \̈捂
     * @return \łȂ̐擪ʒu
     */
    private int printLines( String s, int x, int y, int w, int h ) {
        int ascent = f.getAscent();
        int fh     = f.getHeight();
        int border = y + h;

        int len = s.length();
        char[] c = new char[len];
        s.getChars( 0, len, c, 0 );

        g.setColor( g.getColorOfName( g.WHITE ) );
        int i = 0;
        while( i < len && y < border ) {
            int k = s.indexOf( '\n', i ) + 1;
            if( k == 0 )
                k = len;
            int j = f.getLineBreak( s, i, k - i, w ) - i;
            g.drawChars( c, x, y + ascent, i, j );
            i += j;
            y += fh;
        }
        return i;
    }

    /**
     * wi`
     * @param g `Ώ
     * @param y ʒuy ł邱
     * @param h 
     * @param selected I
     */
    private void clearRow( Graphics g, int y, int h, boolean selected ) {
        int c0 = g.getColorOfRGB( 50, 50, 130 );
        int c1 = g.getColorOfRGB( 70, 70, 150 );
        if( selected ) {
            c0 = g.getColorOfRGB( 150, 50, 130 );
            c1 = g.getColorOfRGB( 170, 70, 150 );
        }
        for( int i = y; i < y + h; i += 2 ) {
            g.setColor( (i % 4 == 0) ? c0 : c1 );
            g.drawRect( 0, i, w, 1 );
        }
    }

    /**
     * L[̂҂
     * @return L[R[h(Display.KEY_1Ȃ)
     */
    public int keyWait() {
        while( true ) {
            int k = getKey();
            if( k >= 0 )
                return k;
            try { Thread.sleep( 10 ); } catch( Exception e ) {}
        }
    }

    /**
     * L[̂҂
     * @param timeout ő҂(~b) 0̂Ƃ^CAEgȂ
     * @return L[ꂽƂtrue ^CAEgƂfalse
     */
    public boolean relWait( int timeout ) {
        long t = System.currentTimeMillis() + timeout;
        while( timeout == 0 || System.currentTimeMillis() < t ) {
            if( getKey() < 0 )
                return true;
            try {
                Thread.sleep( 10 );
            } catch( Exception e ) {
            }
        }
        return false;
    }

    /**
     * L[
     * ĂL[̃L[R[h(Display.KEY_1Ȃ)𒼐ڕԂ
     * ̓L[R[h̑傫قD悳
     * @return L[R[h -1Ȃ͂Ȃ
     */
    int getKey() {
        int k = getKeypadState();
        int i = -1;
        while( k != 0 ) {
            k >>>= 1;
            i++;
        }
        return i;
    }

}
