<?php
// $Horde: imp/lib/Maintenance/Task/delete_sentmail_monthly.php,v 1.1.2.4 2002/06/04 02:22:51 chuck Exp $

/**
* Maintenance module that deletes old sent-mail folders.
*
* @author  Michael Slusarz <slusarz@bigworm.colorado.edu>
* @version $Revision: 1.1.1.1 $
* @since   IMP 2.3.7
* @package horde.maintenance
*/
class Maintenance_Task_delete_sentmail_monthly extends Maintenance_Task {

    /**
     * Purge the old sent-mail folders.
     *
     * @access public
     *
     * @return boolean $status  Whether any sent-mail folders were deleted.
     *
     */
    function doMaintenance()
    {
        global $imp, $prefs;

        /* Get list of all folders, parse through and get the list of all
           old sent-mail folders. Then sort this array according to
           the date. */
        include_once IMP_BASE . '/lib/Folder.php';
        include_once IMP_BASE . '/lib/Identity/IMP.php';
        $identity = new Identity_IMP();
        $sent_mail_folders = $identity->getAllSentmailFolders();

        $folder_array = array();
        $old_folders = IMP_Folder::flist($imp['stream'], IMP::serverString(), IMP::preambleString());

        foreach (array_keys($old_folders) as $k) {
            foreach ($sent_mail_folders as $sent_mail_folder) {
                if (preg_match('/^' . str_replace('/', '\/', $sent_mail_folder) . '-([a-z]{3})-([0-9]{4})$/i', $k, $regs)) {
                    $folder_array[$k] = strtotime("$regs[1] 1, $regs[2]");
                }
            }
        }
        arsort($folder_array, SORT_NUMERIC);

        /* See if any folders need to be purged. */
        $purge_folders = array_slice(array_keys($folder_array), $prefs->getValue('delete_sentmail_monthly_keep'));
        if (count($purge_folders)) {
            Horde::raiseMessage(_("Old sent-mail folders being purged."), HORDE_MESSAGE);

            /* Delete the old folders now. */
            if (IMP_Folder::delete($imp['stream'], $purge_folders, $prefs->getValue('subscribe'))) {
                return true;
            }
        }

        return false;
    }

    /**
     * Return information for the maintenance function.
     *
     * @access public
     *
     * @return string $info  Description of what the operation is going to do
     *                       during this login.
     */
    function describeMaintenance()
    {
        global $prefs;

        return sprintf(_("All old sent-mail folders more than %s months old will be deleted."), $prefs->getValue('delete_sentmail_monthly_keep'));
    }

}
?>
