<?php

/***************************************************************
 Functions to convert UTF
					2000/08/04
					Coded by Kazuhiko Iwama
					iwama@ymc.ne.jp
 ---------------------------------------------------------------
 ܤϡRFC 2060 
 5.1.3 Mailbox International Naming Convertion 򻲹ͤΤ
 ƼǤǡͳˤȤ
 ***************************************************************/

/***  utf16to8() : UTF-16  UTF-8 Ѵ  ***/
function utf16to8 ( $utf16 ){
    $utf8 = "";
    $array = unpack("C*", $utf16);
    $l = count($array);
    for ($i = 1 ; $i <= $l ; $i+=2 ){
	$c1 = $array[$i];
	if ( $i+1 <= $l ){ 
	    $c2 = $array[$i+1];
	} else {
	    $c2 = 0;
	}
	$u1 = 0xE0 | (( $c1 >> 4 ) & 0x0f );
	$u2 = 0x80 | (( $c1 << 2 ) & 0x3c ) | (( $c2 >> 6 ) & 0x03 );
	$u3 = 0x80 | (( $c2      ) & 0x3f );
	$utf8 .= pack("CCC", $u1, $u2, $u3);
    }
    return $utf8;
};

/***  utf8to16() : UTF-8  UTF-16 Ѵ  ***/
function utf8to16 ( $utf8 ){
    $utf16 = "";
    $array= unpack("C*", "$utf8");
    $l = count($array);
    $i = 1;
    while ($i <= $l){
	$c1 = $array[$i++];
	$m = ($c1 & 0xE0);
	if ( ($c1 & 0x80) == 0x00 ){
	    $u1 = 0;
	    $u2 = $c1;
	} else if ( ($c1 & 0xE0) == 0xC0 ){
	    $c2 = $array[$i++];
	    $u1 = (( $c1 >> 2 ) & 0x07 )                 & 0x07;
	    $u2 = (( $c1 << 6 ) & 0xC0 ) | ( $c2 & 0x3F );
	} else if ( ($c1 & 0xF0) == 0xE0 ){
	    $c2 = $array[$i++];
	    $c3 = $array[$i++];
	    $u1 = (( $c1 << 4 ) & 0xF0 ) | (( $c2 >> 2 ) & 0x0F );
	    $u2 = (( $c2 << 6 ) & 0xC0 ) | (  $c3        & 0x3F );
	}
	$utf16 .= pack("CC", $u1, $u2);
    }
    return $utf16;
};

/***  decode_imap_utf7() :  UTF-7  UTF-8 Ѵ  ***/
function decode_imap_utf7 ( $folder ){
    $retval = "";
    $p = strpos( $folder, '&' );
    if ( !strlen($p) && !$p ){
	$retval = $folder;
    } else { 
	while ( !(!strlen($p) && !$p) ){
	    if ( $p > 0 ){
		$retval .= substr($folder, 0, $p);
	    }
	    $folder = substr($folder, $p +1);
	    $p = strpos( $folder, '-' );
	    if ( !strlen($p) && !$p ){
		$mbstr = $folder;
		$folder = "";
	    } else {
		$mbstr = "";
		if ( $p == 0 ){
		    $retval .= "&";
		} else if ( $p > 0 ){
		    $mbstr = substr($folder, 0, $p);
		}
		$folder = substr($folder, $p +1);
	    }
	    $retval .= utf16to8(imap_base64( ereg_replace(",", "/",$mbstr) ));
	    $p = strpos( $folder, '&' );
	}
	$retval .= $folder;
    }
    return $retval;
};

/***  encode_imap_utf7() : UTF-8   UTF-7 Ѵ  ***/
function encode_imap_utf7 ( $folder ){
    $retval = "";
    $utf16 = utf8to16( $folder );
    $array = unpack( "n*", $utf16 );
    $l = count($array);
    $i = 1;
    while ($i <= $l){
	$c = $array[$i++];
	if ( $c >= 0x20 && $c <= 0x7e ){
	    if ( $c == 0x26 ){
		$retval .= "&-";
	    } else {  
		$retval .= pack("C", $c);
	    }
	} else {
	    $mbstr = pack("n", $c);
	    $c = $array[$i];
	    while ( $c < 0x20 || $c > 0x7e ){
		$mbstr .= pack("n", $array[$i++]);
		if ( $i > $l ){
		    break;
		}
		$c = $array[$i];
	    };
	    $mbstr = imap_binary( $mbstr );
	    $mbstr = ereg_replace( '/', ',', $mbstr );
	    $mbstr = ereg_replace( '=', '', $mbstr );
	    $retval .= "&" . chop($mbstr) . "-";
	}
    }
    return $retval;
}

/***  mb_imap_utf7_encode() : imap_utf7_encode()Υåѡؿ ***/
function mb_imap_utf7_encode ( $str ){
    if ($GLOBALS['language'] == 'ja_JP')
	return encode_imap_utf7(mb_convert_encoding($str, 'UTF-8', mb_internal_encoding()));
    else
	return imap_utf7_encode($str);
}

/***  mb_imap_utf7_decode() : imap_utf7_decode()Υåѡؿ ***/
function mb_imap_utf7_decode ( $str ){
    if ($GLOBALS['language'] == 'ja_JP')
	return mb_convert_encoding(decode_imap_utf7($str), mb_internal_encoding(), 'UTF-8');
    else
	return imap_utf7_decode($str);
}

?>