<?php
/*
 * $Horde: imp/search.php,v 2.71.2.6 2002/06/05 22:49:04 jan Exp $
 *
 * Copyright 1999-2002 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999-2002 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('IMP_BASE', dirname(__FILE__));
require_once IMP_BASE . '/lib/base.php';

if (($reason = IMP::authenticate(OP_HALFOPEN, true)) !== true) {
    header('Location: ' . Horde::applicationUrl(IMP::logoutUrl('login.php?url=' . Horde::selfUrl(), $reason), true));
    exit;
}

if ($conf['compress_pages']) {
    ob_start('ob_gzhandler');
}

$title = _("Message Search");
$js_onLoad = null;
require IMP_TEMPLATES . '/common-header.inc';
require IMP_BASE . '/menu.php';
require IMP_BASE . '/status.php';

$newcol = 1;
$numcolumns = 1;
$search_folders = '';
$mailboxes = IMP::flist();
$total = count($mailboxes);
foreach ($mailboxes as $mbox) {
    if (!empty($mbox['val'])) {
        $newcol++;
        $search_folders .= '<input type="checkbox" name="search_folders[]" ';
        $search_folders .= 'value="' . $mbox['val'] . '"';
        if ($mbox['label'] == 'INBOX') {
            $search_folders .= ' checked="checked"';
        }
        $search_folders .= ' />' . str_replace(' ', '&nbsp;', htmlspecialchars($mbox['label'])) . "<br />\n";

        if (($newcol > ceil($total / 3)) && ($numcolumns != 3)) {
            $newcol = 1;
            $numcolumns++;
            $search_folders .= "</td>\n";
            $search_folders .= '<td class="control" valign="top" align="left">';
        }
    }
}

require IMP_TEMPLATES . '/search/javascript.inc';
require IMP_TEMPLATES . '/search/main.inc';

$registry->shutdown();

require IMP_TEMPLATES . '/common-footer.inc';

?>
