<?php
/*
 * $Horde: turba/browse.php,v 1.3.2.4 2002/06/03 16:37:55 chuck Exp $
 *
 * Turba: Copyright 2000-2002 Charles J. Hagenbuch <chuck@horde.org>
 *
 * You should have received a copy of the GNU Public
 * License along with this package; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

define('TURBA_BASE', dirname(__FILE__));
require_once TURBA_BASE . '/lib/base.php';
require_once TURBA_BASE . '/lib/Source.php';
require TURBA_BASE . '/config/attributes.php';

if ($browser->hasFeature('wml')) {
    $registry->applications['turba']['templates'] .= '/wml';
}
$title = _("Address Book Listing");
$js_onLoad = null;
require TURBA_TEMPLATES . '/common-header.inc';

/* Build the directory sources select widget. */
$source = Horde::getFormData('source');
$source_options = '';
$source_count = 0;
foreach ($cfgSources as $key => $entry) {
    if (!empty($entry['export'])) {
        $selected = ($key == $source) ? ' selected="selected"' : '';
        $source_options .= "<option value=\"$key\"$selected>";
        $source_options .= $entry['title'] . "</option>\n";

        $source_count++;
        $bsource = $key;
    }
}

/* Select the source to browse if there is only one or one is
   selected. */
if ($source_count == 0) {
    Horde::raiseMessage(_("There are no browseable address books."), HORDE_WARNING);
} elseif ($source_count == 1) {
    $source = $bsource;
}
if (!is_null($source)) {
    $driver = &Turba_Source::singleton($source, $cfgSources[$source]);
    if (PEAR::isError($driver)) {
        Horde::raiseMessage(_("Failed to access the specified address book."), HORDE_ERROR);
    } else {
        if (!is_object($results = $driver->search(array()))) {
            Horde::raiseMessage(sprintf(_("Failed to browse %s."), $driver->title), HORDE_ERROR);
        } elseif ($results->count() == 0) {
            Horde::raiseMessage(sprintf(_("There are no entries in %s."), $driver->title), HORDE_WARNING);
        }
    }
}

// Read the columns to display from the preferences
$sources = Turba::string2Columns($GLOBALS['prefs']->getValue('columns'));
$columns = isset($sources[$source]) ? $sources[$source] : array();
$width = floor(100 / (count($columns) + 1));

// Has to be after the search for WAP. Also allows us to raise errors
// during the search and have the Notification system handle them.
require TURBA_BASE . '/menu.php';
require TURBA_BASE . '/status.php';
require TURBA_TEMPLATES . '/browse/head.inc';

$numDisplayed = 0;
if (isset($results) && $results->count() > 0) {
    include_once TURBA_BASE . '/lib/ListView.php';
    $display = new Turba_ListView($results, TURBA_TEMPLATES . '/search/row.inc');
    $numDisplayed = $display->display();
}

require TURBA_TEMPLATES . '/browse/foot.inc';

if (!$browser->hasFeature('wml')) {
    $registry->shutdown();
}

require TURBA_TEMPLATES . '/common-footer.inc';

?>
