<?php
/*
 * $Horde: turba/search.php,v 1.47.2.10 2002/05/27 03:04:21 chuck Exp $
 *
 * Turba: Copyright 2000-2002 Charles J. Hagenbuch <chuck@horde.org>
 *
 * You should have received a copy of the GNU Public
 * License along with this package; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

define('TURBA_BASE', dirname(__FILE__));
require_once TURBA_BASE . '/lib/base.php';
require_once TURBA_BASE . '/lib/Source.php';
require TURBA_BASE . '/config/attributes.php';

if ($browser->hasFeature('wml')) {
    $registry->applications['turba']['templates'] .= '/wml';
}
$title = _("Search");
$js_onLoad = null;
require TURBA_TEMPLATES . '/common-header.inc';

// Make sure the search session variable is registered in the session,
// and obtain a global-scope reference to it.
if (!session_is_registered('turba_search_results')) {
    $turba_search_results = null;
    $HTTP_SESSION_VARS['turba_search_results'] = &$turba_search_results;

    session_register('turba_search_results');
} else {
    if (!isset($turba_search_results)) {
        $turba_search_results = &$HTTP_SESSION_VARS['turba_search_results'];
    }
    if (Horde::getFormData('clear')) {
        $turba_search_results = null;
    } elseif (!empty($turba_search_results)) {
        require_once TURBA_BASE . '/lib/List.php';
        require_once TURBA_BASE . '/lib/Object.php';
        $turba_search_results = Turba_List::unserialize($turba_search_results);
    }
}

/* run search if there is one */
$source = Horde::getFormData('source');
if (!isset($source) && isset($cfgSources) && is_array($cfgSources) && count($cfgSources) > 0) {
    reset($cfgSources);
    $source = key($cfgSources);
}

$criteria = Horde::getFormData('criteria');
$val = Horde::getFormData('val');
if (isset($criteria) && isset($val)) {
    $driver = &Turba_Source::singleton($source, $cfgSources[$source]);
    if (PEAR::isError($driver)) {
        Horde::raiseMessage(_("Failed to connect to the specified directory."), HORDE_ERROR);
    } else {
        if (is_object($results = $driver->search(array($criteria => $val)))) {
            if (!is_object($turba_search_results)) {
                $turba_search_results = new Turba_List();
            }
            $turba_search_results->merge($results);
        } else {
            Horde::raiseMessage(sprintf(_("Failed to search the directory: %s"), ''), HORDE_ERROR);
        }
    }
}

/* Build the directory sources select widget. */
$source_options = '';
$criteria_options = '';
$js_criteria = "var criteriaOptions = new Array();\n";
$source_count = 0;
foreach ($cfgSources as $key => $entry) {
    $js_criteria .= "criteriaOptions[$source_count] = new Array()\n";
    $js_criteria .= "criteriaOptions[$source_count][0] = '$key';\n";

    /* Build the criteria select widget. */
    $field_count = 1;
    foreach ($entry['search'] as $field) {
        $js_criteria .= "criteriaOptions[$source_count][$field_count] = new Array('$field', '" . $attributes[$field]['desc'] . "');\n";
        if ($key == $source) {
            $selected = ($field == $criteria) ? ' selected="selected"' : '';
            $criteria_options .= "<option value=\"$field\"$selected>";
            $criteria_options .= $attributes[$field]['desc'] . "</option>\n";
        }
        $field_count++;
    }

    $selected = ($key == $source) ? ' selected="selected"' : '';
    $source_options .= "<option value=\"$key\"$selected>";
    $source_options .= $entry['title'] . "</option>\n";

    $source_count++;
}

// Read the columns to display from the preferences
$sources = Turba::string2Columns($GLOBALS['prefs']->getValue('columns'));
$columns = isset($sources[$source]) ? $sources[$source] : array();
$width = floor(100 / (count($columns) + 1));

// Has to be after the search for WAP. Also allows us to raise errors
// during the search and have the status system handle them.
require TURBA_BASE . '/menu.php';
require TURBA_BASE . '/status.php';
require TURBA_TEMPLATES . '/search/head.inc';

$numDisplayed = 0;
if (is_object($turba_search_results) && $turba_search_results->count() > 0) {
    include_once TURBA_BASE . '/lib/ListView.php';
    $display = new Turba_ListView($turba_search_results, TURBA_TEMPLATES . '/search/row.inc');
    $numDisplayed = $display->display();
    $turba_search_results = $turba_search_results->serialize();
}

require TURBA_TEMPLATES . '/search/foot.inc';

if (!$browser->hasFeature('wml')) {
    $registry->shutdown();
}

require TURBA_TEMPLATES . '/common-footer.inc';

?>
