<?php
// $Horde: turba/lib/Object.php,v 1.6.2.4 2002/09/13 21:43:05 jan Exp $

require_once TURBA_BASE . '/lib/AbstractObject.php';

/**
 * The Turba_Object:: class provides a set of methods for dealing with
 * individual Turba objects - whether those are people, restaurants, etc.
 *
 * @author  Chuck Hagenbuch <chuck@horde.org>
 * @author  Jon Parise <jon@csh.rit.edu>
 * @version $Revision: 1.2 $
 * @since   Turba 0.0.1
 * @package turba
 */
class Turba_Object extends Turba_AbstractObject {

    /**
     * Constructs a new Turba_Object() object.
     *
     * @param $source       Hash describing the object Source.
     * @param $attributes   (optional) Hash of attributes for this object.
     */
    function Turba_Object(&$source, $attributes = array())
    {
        parent::Turba_AbstractObject($source, $attributes);
        $this->attributes['__type'] = 'Object';
    }

    /**
     * Return a hash of Turba data from a vCard object.
     *
     * @param array             $card   The card to convert.
     * @param object Data_vcard $vcard  The Data:: object to use.
     *
     * @return array $hash   The Turba-format data.
     *
     * @since Turba 1.2
     */
    function fromvCard($card, $vcard)
    {
        $hash = array();
        foreach ($card['params'] as $item) {
            switch ($item['name']) {

            case 'FN':
                $hash['name'] = $vcard->read($item);
                break;

            case 'NICKNAME':
                $hash['alias'] = $vcard->read($item);
                break;

            // We use LABEL but should probably use ADR.
            case 'LABEL':
                if (isset($item['params']['HOME'])) {
                    $hash['homeAddress'] = $vcard->read($item);
                } elseif (isset($item['params']['WORK'])) {
                    $hash['workAddress'] = $vcard->read($item);
                } else {
                    $hash['workAddress'] = $vcard->read($item);
                }
                break;

            case 'TEL':
                if (isset($item['params']['VOICE'])) {
                    if (isset($item['params']['HOME'])) {
                        $hash['homePhone'] = $vcard->read($item);
                    } elseif (isset($item['params']['WORK'])) {
                        $hash['workPhone'] = $vcard->read($item);
                    } elseif (isset($item['params']['CELL'])) {
                        $hash['cellPhone'] = $vcard->read($item);
                    }
                } elseif (isset($item['params']['FAX'])) {
                    $hash['fax'] = $vcard->read($item);
                }
                break;

            case 'EMAIL':
                if (isset($item['params']['PREF']) || !isset($hash['email'])) {
                    $hash['email'] = Turba::getBareEmail($vcard->read($item));
                }
                break;

            case 'TITLE':
                $hash['title'] = $vcard->read($item);
                break;

            case 'ORG':
                $units = array();
                for ($i = 0; $i < count($item['values']); $i++) {
                    $units[] = $vcard->read($item, $i);
                }
                $hash['company'] = implode(', ', $units);
                break;

            case 'NOTE':
                $hash['notes'] = $vcard->read($item);
                break;
            }
        }

        return $hash;
    }

}
