/******************************************************************************/
/*! @file table_koi8_unicode.h
    @brief Header file of KOI8/UCS-2 table.
    @author Tachibanamasashi, Apolloron Project.
 ******************************************************************************/

#ifndef _TABLE_KOI8_UNICODE_H_
#define _TABLE_KOI8_UNICODE_H_

namespace apolloron {

#define KOI8_UNICODE_TABLE_MAX 128

/* KOI8-R  0x80-0xFF */
extern const unsigned char koi8_r_unicode[KOI8_UNICODE_TABLE_MAX][2];

/* KOI8-U  0x80-0xFF */
extern const unsigned char koi8_u_unicode[KOI8_UNICODE_TABLE_MAX][2];

/* CP1251  0x80-0xFF */
extern const unsigned char cp1251_unicode[KOI8_UNICODE_TABLE_MAX][2];


} // namespace apolloron
#endif
