/******************************************************************************/
/*! @file msg_zh_cn.cc
    @brief DateTime messages of Chinese(generic).
    @author Tachibanamasashi, Apolloron Project.
 ******************************************************************************/

namespace apolloron {

/*
  Date and time messages in UTF-8
  %Y=year, %m=month, %d=day, %H=hour, %M=minute, %S=second,
  %y=year(range 00 to 99),
  %B=the full month name, %b=abbreviated month name,
  %A=the full weekday name, %a=abbreviated week
*/
const char *calendar_msg_zh_cn[][2] = {
  {"YEAR",              "%Y年"},
  {"MONTH",             "%m月"},
  {"YEARMONTH",         "%Y年%m月"},
  {"DAY",               "%d日"},
  {"DATE",              "%Y年%m月%d日"},
  {"DATE_SHORT",        "%y/%m/%d"},
  {"DATE_WDAY",         "%Y年%m月%d日(%a)"},
  {"DATE_SHORT_WDAY",   "%y/%m/%d (%a)"},
  {"MONTHDAY",          "%m月%d日"},
  {"MONTHDAY_WDAY",     "%m月%d日 (%a)"},
  {"MONTHDAY_SHORT",    "%m/%d"},
  {"MONTHDAY_SHORT_WDAY","%m/%d (%a)"},
  {"HOUR",              "%H点"},
  {"MINUTE",            "%M分"},
  {"SECOND",            "%S秒"},
  {"WDAY",              "%a"},
  {"WDAY_LONG",         "%A"},
  {"TIME",              "%H点%M分"},
  {"TIME_SEC",          "%H点%M分%S秒"},
  {"DATETIME",          "%Y年%m月%d日 %H:%M"},
  {"DATETIME_SEC",      "%Y年%m月%d日 %H:%M:%S"},
  {"DATETIME_WDAY",     "%Y年%m月%d日(%a) %H:%M"},
  {"DATETIME_WDAY_SEC", "%Y年%m月%d日(%a) %H:%M:%S"},
  {"WDAY_SUN",          "日"},
  {"WDAY_MON",          "月"},
  {"WDAY_TUE",          "火"},
  {"WDAY_WED",          "水"},
  {"WDAY_THU",          "木"},
  {"WDAY_FRI",          "金"},
  {"WDAY_SAT",          "土"},
  {"WDAY_SUN_LONG",     "星期日"},
  {"WDAY_MON_LONG",     "星期一"},
  {"WDAY_TUE_LONG",     "星期二"},
  {"WDAY_WED_LONG",     "星期三"},
  {"WDAY_THU_LONG",     "星期四"},
  {"WDAY_FRI_LONG",     "星期五"},
  {"WDAY_SAT_LONG",     "星期六"},
  {"MONTH1",            "1月"},
  {"MONTH2",            "2月"},
  {"MONTH3",            "3月"},
  {"MONTH4",            "4月"},
  {"MONTH5",            "5月"},
  {"MONTH6",            "6月"},
  {"MONTH7",            "7月"},
  {"MONTH8",            "8月"},
  {"MONTH9",            "9月"},
  {"MONTH10",           "10月"},
  {"MONTH11",           "11月"},
  {"MONTH12",           "12月"},
  {"MONTH1_LONG",       "1月"},
  {"MONTH2_LONG",       "2月"},
  {"MONTH3_LONG",       "3月"},
  {"MONTH4_LONG",       "4月"},
  {"MONTH5_LONG",       "5月"},
  {"MONTH6_LONG",       "6月"},
  {"MONTH7_LONG",       "7月"},
  {"MONTH8_LONG",       "8月"},
  {"MONTH9_LONG",       "9月"},
  {"MONTH10_LONG",      "10月"},
  {"MONTH11_LONG",      "11月"},
  {"MONTH12_LONG",      "12月"},
  {(const char*)0,      (const char *)0}
};


} // namespace apolloron
