package ipatjava.analyzer;
import ipatjava.graph.DataTable;
import ipatjava.graph.FlowGraph;

import java.util.BitSet;

public class DataAnalyzer extends DataTable
{
    protected FlowGraph flowGraph;

    protected BitSet writeTable = new BitSet();
    protected BitSet readTable = new BitSet();
    protected BitSet reductionTable = new BitSet();
    
    public DataAnalyzer(FlowGraph flowGraph)
    {
	super(flowGraph.getData(),flowGraph.getNode());
	this.flowGraph=flowGraph;
	
    }

    public FlowGraph getFlowGraph(){return this.flowGraph;}

    public BitSet writeTable(){return writeTable;}
    public BitSet readTable(){return readTable;}
    public BitSet reductionTable(){return reductionTable;}
   
}