package ipatjava.analyzer.array;
import ipatjava.analyzer.DataAnalyzer;
import ipatjava.data.Data;
import ipatjava.data.expr.ExprData;
import ipatjava.data.term.array.ArrayTermData;
import ipatjava.data.term.function.FunctionTermData;
import ipatjava.graph.FlowGraph;
import ipatjava.tips.BitSetTips;
import ipatjava.tips.XobjectTips;

import java.util.BitSet;
import java.util.ListIterator;

public class ArrayDataAnalyzer extends DataAnalyzer
{
	
	public BitSet[] output;
	public BitSet[] flowAnti;
	public BitSet[] input;
	public BitSet[] containFunctionCall;
	public BitSet[] containArray;
	public boolean[] isLinearExpr;
	
	public ArrayDataAnalyzer(FlowGraph flowGraph)
	{
		super(flowGraph);
		
		setData();
		checkContainTerms();
		checkIsLinear();
		calcDependenceCandidate();
	}
	
	private void setData()
	{
		BitSet node = (BitSet)this.flowGraph.getNode().clone();
		BitSet array = new BitSet();
		
		for(int i = node.nextSetBit(0) ; i!=-1 ;i = node.nextSetBit(i+1))
		{
			Data d1 = (Data)this.data.getDataList().get(i);
			for(int j= d1.getChildDataIndex().nextSetBit(0) ; j!=-1 ; j= d1.getChildDataIndex().nextSetBit(j+1))
			{
				Data d2 = (Data)this.data.getDataList().get(j);
				if(d2 instanceof ArrayTermData)
					array.set(j);
			}
		}
		
		super.setTable(array);
		
		for(int i= node.nextSetBit(0) ; i!=-1 ; i= node.nextSetBit(i+1))
		{
			Data d1 = (Data)this.data.getDataList().get(i);
			BitSet tmp = BitSetTips.and(array,(BitSet)d1.getChildDataIndex());
			super.set(flowGraph.getNodeIndex(i),super.getTableIndexBitSet((BitSet)tmp.clone()));
		}
		
		int size = super.size();
		for(int i=0;i<size;i++)
		{
			BitSet tmp = (BitSet)super.getGraph(i).clone();
			for(int j = tmp.nextSetBit(0) ; j!=-1 ; j = tmp.nextSetBit(j+1))
			{
				ArrayTermData atd1 = (ArrayTermData)this.data.getDataList().get(super.getTableDataIndex(j));
				if(atd1.isWrite())
					writeTable.set(j);
				if(atd1.isRead())
					readTable.set(j);
				if(atd1.isReduction())
					reductionTable.set(j);
			}
		}		
		
	}
	
	private void  checkContainTerms()
	{
		int size = super.table.cardinality();
		
		containFunctionCall = new BitSet[size];
		for(int i = 0 ; i < size ; containFunctionCall[i++] = new BitSet());
		containArray = new BitSet[size];
		for(int i = 0 ; i < size ; containArray[i++] = new BitSet());
		
		
		for(int i=super.table.nextSetBit(0);i!=-1;i=super.table.nextSetBit(i+1))
		{
			ArrayTermData arrayTermData = (ArrayTermData)this.data.getDataList().get(i);
			
			for(int j = 0  ; j< arrayTermData.getElementSize();j++)
			{
				ExprData exprData = arrayTermData.getElement(j);
				if(exprData instanceof FunctionTermData)
					containFunctionCall[super.getTableIndex(i)].set(exprData.getDataIndex());
				if(exprData instanceof ArrayTermData)
					containArray[super.getTableIndex(i)].set(exprData.getDataIndex());    				

				for(ListIterator listIterator = exprData.getDataList().listIterator();listIterator.hasNext();)
				{
					Data data = (Data)listIterator.next();
					if(data instanceof FunctionTermData)
						containFunctionCall[super.getTableIndex(i)].set(data.getDataIndex());
					if(data instanceof ArrayTermData)
						containArray[super.getTableIndex(i)].set(data.getDataIndex());    				
				}
			}
		}
		
	}
	
	private void  checkIsLinear()
	{
		int size = super.table.cardinality();
		isLinearExpr = new boolean[size];
		
		
		for(int i=super.table.nextSetBit(0);i!=-1;i=super.table.nextSetBit(i+1))
		{
			ArrayTermData arrayTermData = (ArrayTermData)this.data.getDataList().get(i);
			isLinearExpr[super.getTableIndex(i)]=true;
			for(int j = 0  ; j< arrayTermData.getElementSize();j++)
			{	
				ExprData exprData = arrayTermData.getElement(j);
				if(exprData.getIdValueList()==null)
					isLinearExpr[super.getTableIndex(i)] = false; 
			}
		}
	}
	
	private void calcDependenceCandidate()
	{
		int size = super.table.cardinality();
		BitSet node = super.getNode();
		
		output = new BitSet[size];
		for(int i = 0 ; i < size ; output[i++] = new BitSet());
		flowAnti = new BitSet[size];
		for(int i = 0 ; i < size ; flowAnti[i++] = new BitSet());
		input = new BitSet[size];
		for(int i = 0 ; i < size ; input[i++] = new BitSet());
		
		for(int i = super.table.nextSetBit(0) ; i !=-1 ; i = super.table.nextSetBit(i+1))
		{
			ArrayTermData atd1 = (ArrayTermData)this.data.getDataList().get(i);
			for(int j=super.table.nextSetBit(0);j!=-1;j=super.table.nextSetBit(j+1))
			{
				if(i==j)
					continue;
				ArrayTermData atd2 = (ArrayTermData)this.data.getDataList().get(j);
				if(XobjectTips.sameXobject(atd1.getArrayID(),atd2.getArrayID()))
				{
					if(atd1.isWrite() && atd2.isWrite())
						output[super.getTableIndex(i)].set(super.getTableIndex(j));
					if(atd1.isWrite() && atd2.isRead())
						flowAnti[super.getTableIndex(i)].set(super.getTableIndex(j));
					if(atd1.isRead() && atd2.isWrite())
						flowAnti[super.getTableIndex(i)].set(super.getTableIndex(j));
					if(atd1.isRead() && atd2.isRead())
						input[super.getTableIndex(i)].set(super.getTableIndex(j));
				}
			}
		}
		/*
		 for(int i=0;i<size;i++)
		 System.out.println(i+":output"+output[i].toString()+":flowAnti"+flowAnti[i].toString()+":input"+input[i].toString());
		 */	
	}
	
	public BitSet writeTable(){return writeTable;}
	public BitSet readTable(){return readTable;}
	public BitSet reductionTable(){return reductionTable;}
	
	public BitSet[] output(){return output;}
	public BitSet[] flowAnti(){return flowAnti;}
	public BitSet[] input(){return input;}
	
	public BitSet[] containFunctionCall(){return this.containFunctionCall;}
	public BitSet[] containArray(){return this.containArray;}
	public boolean[] isLinearExpr(){return this.isLinearExpr;}
	
	
}
