package ipatjava.analyzer.array.powertest;
import ipatjava.math.*;
import ipatjava.tips.*;

public class IndexSpace
{
    int mP[][];
    int vP[];
    int mQ[][];
    int vQ[];
    int mA[][];
    int vA[];
    int invMP[][];
    int mTheta[][];
    Frac invTheta[][];

    public IndexSpace(int mP[][],int vP[],int mQ[][],int vQ[],int mTheta[][],int mA[][],int vA[])
    {
	this.mP=mP;
	this.vP=vP;
	this.mQ=mQ;
	this.vQ=vQ;
	this.mA=mA;
	this.vA=vA;
	this.mTheta=mTheta;

	int size=mP.length;
	invMP=new int[size][size];
	int x[][]=new int[size][size];

	for(int i=0;i<size;i++)
	    for(int j=0;j<size;j++)
		{
		    x[i][j]=this.mP[i][j];
		    if(i==j)
			invMP[i][i]=1;
		    else
			invMP[i][j]=0;
		}
	int t;

	for(int i=0;i<size;i++)
	    for(int j=i+1;j<size;j++)
		{
		    t=x[i][j];
		    for(int k=0;k<size;k++)
			invMP[i][k]-=invMP[j][k]*t;
		    for(int k=0;k<size;k++)
			x[i][k]-=x[j][k]*t;
		}

	invTheta = new Frac[size][size];
	for(int i=0;i<size;i++)
	    for(int j=0;j<size;j++)
		if(i==j)
		    invTheta[i][i]=new Frac(1,mTheta[i][i]);
		else
		    invTheta[i][j]=new Frac(0);
    } 

    public int[][] getSubscriptMatrix()
    {
	return MathTips.multiplyMatrix(this.mTheta,MathTips.multiplyMatrix(this.invMP,this.mA));
    }

    public int[] getSubscriptVector()
    {
	int c[]=MathTips.multiplyMatrix(MathTips.multiplyMatrix(vP,this.invMP),this.mA);
	for(int i=0;i<c.length;i++)
	    c[i]+=this.vA[i];
	return c;
    }

    public Frac[][] getFinalMatrix()
    {
	return MathTips.multiplyMatrix(MathTips.createMatrix(this.mTheta),
			    MathTips.multiplyMatrix(MathTips.createMatrix(this.invMP),
					 MathTips.multiplyMatrix(
						      MathTips.createMatrix(this.mQ),this.invTheta))
			    );
    }

    public Frac[] getFinalVector()
    {
	Frac c[]=MathTips.multiplyMatrix(MathTips.createVector(this.vP),
			      MathTips.multiplyMatrix(MathTips.createMatrix(invMP),
					   MathTips.createMatrix(this.mQ))
			      );
	c=MathTips.subtractVector(MathTips.createVector(this.vQ),c);	
	c=MathTips.multiplyMatrix(c,this.invTheta);
	return c;
    }
}
