package ipatjava.analyzer.scalar;
import ipatjava.analyzer.LocalDataAnalyzer;
import ipatjava.data.Data;

import java.util.BitSet;

public class LocalScalarDataAnalyzer extends LocalDataAnalyzer
{
    public ScalarDataAnalyzer scalarDataAnalyzer;
	private BitSet reductionOnly;

	private BitSet genInner;
    private BitSet genOuter;

    private BitSet killInner;
    private BitSet killOuter;

    private BitSet udChainInner;
    private BitSet udChainOuter;

    private BitSet duChainInner;
    private BitSet duChainOuter;
    
    public LocalScalarDataAnalyzer(ScalarDataAnalyzer scalarDataAnalyzer,Data targetData)
    {
    	super(scalarDataAnalyzer,targetData);
    	this.scalarDataAnalyzer = scalarDataAnalyzer;
	calcInner();
	calcOuter();
	calcReductionOnly();
    }
    
    public BitSet reductionOnly(){return reductionOnly;}
    
    public ScalarDataAnalyzer getGlobalScalarDataFlowAnalyzer(){return this.scalarDataAnalyzer;}
    
    public Data getTargetData(){return targetData;}
    
    public void calcReductionOnly()
    {
	this.reductionOnly = new BitSet();
	for(int i =this.reductionTableInner.nextSetBit(0) ;i!=-1;i=this.reductionTableInner.nextSetBit(i+1))
	    {
		BitSet cond = (BitSet)this.scalarDataAnalyzer.killT()[i].clone();
		cond.and(writeTableInner);
		if(cond.isEmpty())
		    reductionOnly.set(i);
	    }
    }


    public void calcInner()
    {

	this.genInner = new BitSet();
	for(int i = this.nodeInner.nextSetBit(0) ; i!=-1 ; i = this.nodeInner.nextSetBit(i+1))
	    this.genInner.or(this.scalarDataAnalyzer.gen()[i]);


	this.killInner = new BitSet();
	for(int i = this.nodeInner.nextSetBit(0) ; i!=-1 ; i = this.nodeInner.nextSetBit(i+1))
	    this.killInner.or(this.scalarDataAnalyzer.kill()[i]);


	this.udChainInner = new BitSet();
	for(int i = this.tableInner.nextSetBit(0) ; i!=-1 ; i = this.tableInner.nextSetBit(i+1))
	    this.udChainInner.or(this.scalarDataAnalyzer.udChain()[i]);

	this.duChainInner = new BitSet();
	for(int i = this.tableInner.nextSetBit(0) ; i!=-1 ; i = this.tableInner.nextSetBit(i+1))
	    this.duChainInner.or(this.scalarDataAnalyzer.duChain()[i]);
    }

    public BitSet genInner(){return genInner;}
    public BitSet killInner(){return killInner;}
    public BitSet udChainInner(){return udChainInner;}
    public BitSet duChainInner(){return duChainInner;}

    public void calcOuter()
    {

	this.genOuter = new BitSet();
	for(int i = this.nodeOuter.nextSetBit(0) ; i!=-1 ; i = this.nodeOuter.nextSetBit(i+1))
	    this.genOuter.or(this.scalarDataAnalyzer.gen()[i]);

	this.killOuter = new BitSet();
	for(int i = this.nodeOuter.nextSetBit(0) ; i!=-1 ; i = this.nodeOuter.nextSetBit(i+1))
	    this.killOuter.or(this.scalarDataAnalyzer.kill()[i]);

	this.udChainOuter = new BitSet();
	for(int i = this.tableOuter.nextSetBit(0) ; i!=-1 ; i = this.tableOuter.nextSetBit(i+1))
	    this.udChainOuter.or(this.scalarDataAnalyzer.udChain()[i]);

	this.duChainOuter = new BitSet();
	for(int i = this.tableOuter.nextSetBit(0) ; i!=-1 ; i = this.tableOuter.nextSetBit(i+1))
	    this.duChainOuter.or(this.scalarDataAnalyzer.duChain()[i]);
    }

    
    public BitSet redacutionTableOuter(){return reductionTableOuter;}
    public BitSet nodeOuter(){return nodeOuter;}
    public BitSet genOuter(){return genOuter;}
    public BitSet killOuter(){return killOuter;}
    public BitSet udChainOuter(){return udChainOuter;}
    public BitSet duChainOuter(){return duChainOuter;}
}
