package ipatjava.analyzer.scalar;
import ipatjava.analyzer.DataAnalyzer;
import ipatjava.data.Data;
import ipatjava.data.term.scalar.ScalarTermData;
import ipatjava.graph.FlowGraph;
import ipatjava.tips.BitSetTips;
import ipatjava.tips.XobjectTips;

import java.util.BitSet;

public class ScalarDataAnalyzer extends DataAnalyzer
{
	private BitSet[] gen;
    private BitSet[] kill;
    private BitSet[] killT;

    private BitSet[] in;
    private BitSet[] out;

    private BitSet[] def;
    private BitSet[] use;
    
    private BitSet[] live_in;
    private BitSet[] live_out;

    private BitSet[] udChain;
    private BitSet[] duChain;
    
    public ScalarDataAnalyzer(FlowGraph flowGraph)
    {
	super(flowGraph);
	
	setData();
	calcGenKill();
	calcReachingDef();
	calcUseDef();
	calcLiveInOut();
	calcChain();
    }
    
    private void setData()
    {
	BitSet node = (BitSet)this.flowGraph.getNode().clone();
	BitSet scalarTable = new BitSet();

	for(int i = node.nextSetBit(0) ; i!=-1 ;i = node.nextSetBit(i+1))
	    {
		Data data1 = (Data)this.data.getDataList().get(i);
		for(int j= data1.getChildDataIndex().nextSetBit(0) ; j!=-1 ; j= data1.getChildDataIndex().nextSetBit(j+1))
		    {
			Data data2 = (Data)this.data.getDataList().get(j);
			if(data2 instanceof ScalarTermData)
			    scalarTable.set(j);
		    }
	    }

	super.setTable(scalarTable);

	for(int i= node.nextSetBit(0) ; i!=-1 ; i= node.nextSetBit(i+1))
	    {
		Data data1 = (Data)this.data.getDataList().get(i);
		BitSet tmp = BitSetTips.and(scalarTable,(BitSet)data1.getChildDataIndex());
		super.set(flowGraph.getNodeIndex(i),super.getTableIndexBitSet((BitSet)tmp.clone()));
	    }

	int nodeSize = super.size();
	for(int i=0;i<nodeSize;i++)
	    {
		BitSet tmp = (BitSet)super.getGraph(i).clone();
		for(int j = tmp.nextSetBit(0) ; j!=-1 ; j = tmp.nextSetBit(j+1))
		    {
			ScalarTermData scalarTermData1 = (ScalarTermData)this.data.getDataList().get(super.getTableDataIndex(j));
			if(scalarTermData1.isWrite())
			    writeTable.set(j);
			if(scalarTermData1.isRead())
			    readTable.set(j);
			if(scalarTermData1.isReduction())
			    reductionTable.set(j);
		    }
	    }		
    }

    private void calcGenKill()
    {
	int size = super.size();
	gen = new BitSet[size];
	for(int i = 0 ; i < size ; gen[i++] = new BitSet());
	kill = new BitSet[size];
	for(int i = 0 ; i < size ; kill[i++] = new BitSet());

	killT = new BitSet[super.table.cardinality()];
	for(int i = 0 ; i < super.table.cardinality() ; killT[i++] = new BitSet());
 	
	for(int i=0;i<size;i++)
	    {
		BitSet tmp = (BitSet)super.getGraph(i).clone();
		for(int j = tmp.nextSetBit(0) ; j !=-1 ; j = tmp.nextSetBit(j+1))
		    {
			ScalarTermData scalarTermData1 = (ScalarTermData)this.data.getDataList().get(super.getTableDataIndex(j));
			if(!scalarTermData1.isWrite())
			    continue;
			gen[i].set(j);
			for(int k=super.table.nextSetBit(0);k!=-1;k=super.table.nextSetBit(k+1))
			    {
				if(j==super.getTableIndex(k))
				    continue;
				ScalarTermData scalarTermData2 = (ScalarTermData)this.data.getDataList().get(k);
				if(!scalarTermData2.isWrite())
				    continue;
				if(XobjectTips.sameXobject(scalarTermData1.getXobject(),scalarTermData2.getXobject()))
				    {
					kill[i].set(super.getTableIndex(k));
					killT[j].set(super.getTableIndex(k));
				    }
			    }
		    }
		//System.out.println(i+":"+gen[i].toString()+""+kill[i].toString());
	    }
	
    }
    
    private void calcReachingDef()
    {
        int size = this.flowGraph.size();

        BitSet pred[] = this.flowGraph.getPredecessor();
        
        this.out = new BitSet[size];
        for(int i = 0 ; i < size ; i++)
            this.out[i] = (BitSet)this.gen[i].clone(); 

        this.in = new BitSet[size];
        for(int i = 0 ; i < size ; i++)
            this.in[i] = new BitSet(); 

        boolean change = true;

        while(change)
            {
                change = false;
                if(size==0)
                    return;
                for(int i = 0 ; i < size ; i++)
                    {

                        int j = pred[i].nextSetBit(0);

                        if(j!=-1)
                            this.in[i] = (BitSet)this.out[j].clone();

                        j = pred[i].nextSetBit(j+1);
                        
                        while(j != -1)
                            {
                                this.in[i].or(this.out[j]);
                                j = pred[i].nextSetBit(j+1);
                            }

                        BitSet tmp_in = BitSetTips.andNot(this.in[i],this.kill[i]);
                        
                        BitSet oldout = (BitSet)this.out[i].clone();

                        this.out[i] = BitSetTips.or(this.gen[i],tmp_in);

                        oldout.xor(this.out[i]);

                        if(!oldout.isEmpty())
                            change = true;
                    }
            }
        /*
 	for(int i=0;i<size;i++)
	    {
		System.out.println(i+":gen"+gen[i].toString()+":kill"+kill[i].toString()+":in"+in[i].toString()+":out"+out[i].toString());
	    }
	    */
    }

    private void calcUseDef()
    {
	int size = super.size();
	use = new BitSet[size];
	for(int i = 0 ; i < size ; use[i++] = new BitSet());
	def = new BitSet[size];
	for(int i = 0 ; i < size ; def[i++] = new BitSet());
 	
	for(int i=0;i<size;i++)
	    {
		BitSet tmp = (BitSet)super.getGraph(i).clone();
		for(int j = tmp.nextSetBit(0) ; j !=-1 ; j = tmp.nextSetBit(j+1))
		    {
			ScalarTermData std1 = (ScalarTermData)this.data.getDataList().get(super.getTableDataIndex(j));
			
			if(std1.isRead())
			    {
				boolean check = true;
				for(int k=tmp.nextSetBit(0);k!=-1 && k<j ;k=tmp.nextSetBit(k+1))
				    {
					ScalarTermData std2 = (ScalarTermData)this.data.getDataList().get(super.getTableDataIndex(k));
					if(std2.isWrite() &&
					   XobjectTips.sameXobject(std1.getXobject(),std2.getXobject()))
					    check = false;
				    }
				if(!check)
				    continue;
				for(int k=this.in[i].nextSetBit(0);k!=-1;k=this.in[i].nextSetBit(k+1))
				    {
					ScalarTermData std2 = (ScalarTermData)this.data.getDataList().get(super.getTableDataIndex(k));
					if(XobjectTips.sameXobject(std1.getXobject(),std2.getXobject()))
					    use[i].set(k);
				    }
				
			    }
			else
			    {
				if(std1.isReduction())
				    continue;
				boolean check = true;
				for(int k=tmp.nextSetBit(0);k!=-1 && k<j ;k=tmp.nextSetBit(k+1))
				    {
					ScalarTermData std2 = (ScalarTermData)this.data.getDataList().get(super.getTableDataIndex(k));
					if(std2.isRead() &&
					   XobjectTips.sameXobject(std1.getXobject(),std2.getXobject()))
					   check = false;
				    }
				if(check)
				    def[i].set(j);
			    }
		    }
		//System.out.println(i+":use"+use[i].toString()+":def"+def[i].toString());
	    }
	
    }

    private void calcLiveInOut()
    {
        int size = this.flowGraph.size();

        BitSet succ[] = this.flowGraph.getGraph();
        
        this.live_out = new BitSet[size];
        for(int i = 0 ; i < size ; i++)
            this.live_out[i] = new BitSet();

        this.live_in = new BitSet[size];
        for(int i = 0 ; i < size ; i++)
            this.live_in[i] = new BitSet(); 

        boolean change = true;

        while(change)
            {
                change = false;
                if(size==0)
                    return;
                for(int i = 0 ; i < size ; i++)
                    {

                        int j = succ[i].nextSetBit(0);

                        if(j!=-1)
                            this.live_out[i] = (BitSet)this.live_out[j].clone();

                        j = succ[i].nextSetBit(j+1);
                        
                        while(j != -1)
                            {
                                this.live_out[i].or(this.live_in[j]);
                                j = succ[i].nextSetBit(j+1);
                            }

                        BitSet tmp_live_out = BitSetTips.andNot(this.live_out[i],this.def[i]);
                        
                        BitSet oldlive_in = (BitSet)this.live_in[i].clone();

                        this.live_in[i] = BitSetTips.or(this.use[i],tmp_live_out);

                        oldlive_in.xor(this.live_in[i]);

                        if(!oldlive_in.isEmpty())
                            change = true;
                    }
            }
 	/*
        for(int i=0;i<size;i++)
	    {
		System.out.println(i+":gen"+gen[i].toString()+":kill"+kill[i].toString()+":live_in"+live_in[i].toString()+":live_out"+live_out[i].toString());
	    }
	    */
    }
    
    private void calcChain()
    {
	int size = super.size();

	this.duChain = new BitSet[super.table.cardinality()];
	for(int i = 0 ; i < super.table.cardinality() ; this.duChain[i++] = new BitSet());

	this.udChain = new BitSet[super.table.cardinality()];
	for(int i = 0 ; i < super.table.cardinality() ; this.udChain[i++] = new BitSet());

	for(int i=0;i<size;i++)
	    {
		BitSet tmp = (BitSet)super.getGraph(i).clone();
		for(int j = tmp.nextSetBit(0) ; j !=-1 ; j = tmp.nextSetBit(j+1))
		    {
			ScalarTermData std1 = (ScalarTermData)this.data.getDataList().get(super.getTableDataIndex(j));
			if(!std1.isRead())
			    continue;
			for( int k=this.in[i].nextSetBit(0);k!=-1;k=this.in[i].nextSetBit(k+1))
			    {
				ScalarTermData std2 = (ScalarTermData)this.data.getDataList().get(super.getTableDataIndex(k));
				if(XobjectTips.sameXobject(std1.getXobject(),std2.getXobject()))
				    {
					udChain[j].set(k);
					duChain[k].set(j);
				    }
			    }
		    }
	    }
	/*
	for(int i = 0 ; i < super.table.cardinality() ; i++)
	    {
		System.out.println(i+":"+((ScalarTermData)this.data.getDataList().get(super.getTableDataIndex(i))).getXobject().toString()+":"+udChain[i].toString()+""+duChain[i].toString());
	    }
	*/
    }

    
    public BitSet[] gen(){return gen;}
    public BitSet[] kill(){return kill;}
    public BitSet[] killT(){return killT;}
    public BitSet[] in(){return in;}
    public BitSet[] out(){return out;}
    
    public BitSet[] udChain(){return udChain;}
    public BitSet[] duChain(){return duChain;}
}
